/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.datasource.StreamDataSource;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.utils.MessageUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public final class CompositeMailMessage
extends MailMessage {
    private static final long serialVersionUID = -3153633514125635904L;
    private final MailMessage delegate;
    private final transient List<MailPart> additionalParts;
    private final int delegateEnclosedCount;
    private static final String MULTIPART = "multipart/";

    public CompositeMailMessage(MailMessage delegate) throws OXException {
        if (!delegate.getContentType().startsWith(MULTIPART)) {
            throw new IllegalArgumentException("Specified delegate mail must be of MIME type multipart/*");
        }
        this.delegate = delegate;
        if (delegate.containsAppendVCard()) {
            this.setAppendVCard(delegate.isAppendVCard());
        }
        if (delegate.containsBcc()) {
            this.addBcc(delegate.getBcc());
        }
        if (delegate.containsReplyTo()) {
            this.addReplyTo(delegate.getReplyTo());
        }
        if (delegate.containsCc()) {
            this.addCc(delegate.getCc());
        }
        if (delegate.containsColorLabel()) {
            this.setColorLabel(delegate.getColorLabel());
        }
        if (delegate.containsContentId()) {
            this.setContentId(delegate.getContentId());
        }
        if (delegate.containsContentType()) {
            this.setContentType(delegate.getContentType());
        }
        if (delegate.containsContentDisposition()) {
            this.setContentDisposition(delegate.getContentDisposition());
        }
        if (delegate.containsDispositionNotification()) {
            this.setDispositionNotification(delegate.getDispositionNotification());
        }
        if (delegate.containsFileName()) {
            this.setFileName(delegate.getFileName());
        }
        if (delegate.containsFlags()) {
            this.setFlags(delegate.getFlags());
        }
        if (delegate.containsFolder()) {
            this.setFolder(delegate.getFolder());
        }
        if (delegate.containsFrom()) {
            this.addFrom(delegate.getFrom());
        }
        if (delegate.containsHasAttachment()) {
            this.setHasAttachment(delegate.hasAttachment());
        }
        if (delegate.containsHeaders()) {
            int len = delegate.getHeadersSize();
            Iterator<Map.Entry<String, String>> iter = delegate.getHeadersIterator();
            for (int i = 0; i < len; ++i) {
                Map.Entry<String, String> e = iter.next();
                this.addHeader(e.getKey(), e.getValue());
            }
        }
        if (delegate.containsMsgref()) {
            this.setMsgref(delegate.getMsgref());
        }
        if (delegate.containsPriority()) {
            this.setPriority(delegate.getPriority());
        }
        if (delegate.containsReceivedDate()) {
            this.setReceivedDate(delegate.getReceivedDate());
        }
        if (delegate.containsSentDate()) {
            this.setSentDate(delegate.getSentDate());
        }
        if (delegate.containsSequenceId()) {
            this.setSequenceId(delegate.getSequenceId());
        }
        if (delegate.containsSize()) {
            this.setSize(delegate.getSize());
        }
        if (delegate.containsSubject()) {
            this.setSubject(delegate.getSubject());
        }
        if (delegate.containsThreadLevel()) {
            this.setThreadLevel(delegate.getThreadLevel());
        }
        if (delegate.containsTo()) {
            this.addTo(delegate.getTo());
        }
        this.setMailId(delegate.getMailId());
        if (delegate.containsUserFlags()) {
            this.addUserFlags(delegate.getUserFlags());
        }
        this.additionalParts = new ArrayList<MailPart>();
        this.delegateEnclosedCount = delegate.getEnclosedCount();
    }

    public void addAdditionalParts(MailPart mailPart) {
        this.additionalParts.add(mailPart);
    }

    public MailPart removeAdditionalParts(int index) {
        return this.additionalParts.remove(index);
    }

    @Override
    public Object getContent() throws OXException {
        return this.delegate.getContent();
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return this.delegate.getDataHandler();
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return this.delegateEnclosedCount + this.additionalParts.size();
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        if (this.delegateEnclosedCount > 0) {
            if (index >= this.delegateEnclosedCount) {
                try {
                    return this.additionalParts.get(index - this.delegateEnclosedCount);
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
            }
            return this.delegate.getEnclosedMailPart(index);
        }
        try {
            return this.additionalParts.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("No mail part at index " + index);
        }
    }

    @Override
    public InputStream getInputStream() throws OXException {
        return this.delegate.getInputStream();
    }

    @Override
    public void loadContent() throws OXException {
        this.delegate.loadContent();
    }

    @Override
    public void prepareForCaching() {
        this.delegate.prepareForCaching();
    }

    @Override
    public String getMailId() {
        return this.delegate.getMailId();
    }

    @Override
    public void setMailId(String id) {
        this.delegate.setMailId(id);
    }

    @Override
    public int getUnreadMessages() {
        return this.delegate.getUnreadMessages();
    }

    @Override
    public void setUnreadMessages(int unreadMessages) {
        this.delegate.setUnreadMessages(unreadMessages);
    }

    @Override
    public boolean hasHeaders(String ... names) {
        return this.delegate.hasHeaders(names);
    }

    @Override
    public Date getReceivedDateDirect() {
        return this.delegate.getReceivedDateDirect();
    }

    @Override
    public int getRecentCount() {
        return this.delegate.getRecentCount();
    }

    @Override
    public boolean containsRecentCount() {
        return this.delegate.containsRecentCount();
    }

    @Override
    public void removeRecentCount() {
        this.delegate.removeRecentCount();
    }

    @Override
    public void setRecentCount(int recentCount) {
        this.delegate.setRecentCount(recentCount);
    }

    @Override
    public void writeTo(OutputStream out) throws OXException {
        if (this.additionalParts.isEmpty()) {
            this.delegate.writeTo(out);
            return;
        }
        try {
            ContentDisposition contentDisposition;
            String disposition;
            String fileName;
            StreamDataSource.InputStreamProvider isp;
            MimeBodyPart bodyPart;
            MimeMessage mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession());
            int size = this.getHeadersSize();
            Iterator<Map.Entry<String, String>> iter = this.getHeadersIterator();
            for (int i = 0; i < size; ++i) {
                Map.Entry<String, String> entry = iter.next();
                mimeMessage.addHeader(entry.getKey(), entry.getValue());
            }
            MimeMultipart mimeMultipart = new MimeMultipart("mixed");
            for (int i = 0; i < this.delegateEnclosedCount; ++i) {
                final MailPart mp = this.delegate.getEnclosedMailPart(i);
                bodyPart = new MimeBodyPart();
                isp = new StreamDataSource.InputStreamProvider(){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        try {
                            return mp.getInputStream();
                        }
                        catch (OXException e) {
                            IOException io = new IOException(e.getMessage());
                            io.initCause(e);
                            throw io;
                        }
                    }

                    @Override
                    public String getName() {
                        return null;
                    }
                };
                bodyPart.setDataHandler(new DataHandler((DataSource)new StreamDataSource(isp, mp.getContentType().toString())));
                fileName = mp.getFileName();
                if (fileName != null && !mp.getContentType().containsNameParameter()) {
                    mp.getContentType().setNameParameter(fileName);
                }
                bodyPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(mp.getContentType().toString()));
                disposition = bodyPart.getHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, null);
                if (disposition == null) {
                    contentDisposition = mp.getContentDisposition();
                } else {
                    contentDisposition = new ContentDisposition(disposition);
                    contentDisposition.setDisposition(mp.getContentDisposition().getDisposition());
                }
                if (fileName != null && !contentDisposition.containsFilenameParameter()) {
                    contentDisposition.setFilenameParameter(fileName);
                }
                bodyPart.setHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition(contentDisposition.toString()));
                mimeMultipart.addBodyPart((BodyPart)bodyPart);
            }
            for (final MailPart mp : this.additionalParts) {
                bodyPart = new MimeBodyPart();
                isp = new StreamDataSource.InputStreamProvider(){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        try {
                            return mp.getInputStream();
                        }
                        catch (OXException e) {
                            IOException io = new IOException(e.getMessage());
                            io.initCause(e);
                            throw io;
                        }
                    }

                    @Override
                    public String getName() {
                        return null;
                    }
                };
                bodyPart.setDataHandler(new DataHandler((DataSource)new StreamDataSource(isp, mp.getContentType().toString())));
                fileName = mp.getFileName();
                if (fileName != null && !mp.getContentType().containsNameParameter()) {
                    mp.getContentType().setNameParameter(fileName);
                }
                bodyPart.setHeader(MessageHeaders.HDR_CONTENT_TYPE, MimeMessageUtility.foldContentType(mp.getContentType().toString()));
                disposition = bodyPart.getHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, null);
                if (disposition == null) {
                    contentDisposition = mp.getContentDisposition();
                } else {
                    contentDisposition = new ContentDisposition(disposition);
                    contentDisposition.setDisposition(mp.getContentDisposition().getDisposition());
                }
                if (fileName != null && !contentDisposition.containsFilenameParameter()) {
                    contentDisposition.setFilenameParameter(fileName);
                }
                bodyPart.setHeader(MessageHeaders.HDR_CONTENT_DISPOSITION, MimeMessageUtility.foldContentDisposition(contentDisposition.toString()));
                mimeMultipart.addBodyPart((BodyPart)bodyPart);
            }
            MessageUtility.setContent((Multipart)mimeMultipart, (Part)mimeMessage);
            mimeMessage.writeTo(out);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }
}

