/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.compose;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.compose.CompositionSpace;
import com.openexchange.mail.compose.CompositionSpaceRegistry;
import com.openexchange.mailaccount.UnifiedInboxUID;
import com.openexchange.session.Session;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositionSpaces {
    static final Logger LOGGER = LoggerFactory.getLogger(CompositionSpaces.class);

    private CompositionSpaces() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(String csid, Session session) {
        CompositionSpaceRegistry registry = CompositionSpace.getRegistry(session);
        CompositionSpace space = registry.removeCompositionSpace(csid);
        if (null != space) {
            ConcurrentHashMap<Integer, MailAccess<IMailFolderStorage, IMailMessageStorage>> accesses = new ConcurrentHashMap<Integer, MailAccess<IMailFolderStorage, IMailMessageStorage>>(4, 0.9f, 1);
            try {
                MailPath mailPath;
                Queue<MailPath> cleanUps = space.getCleanUps();
                while ((mailPath = cleanUps.poll()) != null) {
                    MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = (MailAccess<IMailFolderStorage, IMailMessageStorage>)accesses.get(mailPath.getAccountId());
                    if (null == mailAccess) {
                        try {
                            mailAccess = MailAccess.getNewInstance(session, mailPath.getAccountId());
                            mailAccess.connect(false);
                            accesses.put(mailPath.getAccountId(), mailAccess);
                        }
                        catch (OXException e) {
                            LOGGER.warn("Could not obtain access for {}", (Object)mailPath.getAccountId(), (Object)e);
                        }
                    }
                    if (null == mailAccess) continue;
                    try {
                        mailAccess.getMessageStorage().deleteMessages(mailPath.getFolder(), new String[]{mailPath.getMailID()}, true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to delete {}", (Object)mailPath, (Object)e);
                    }
                }
            }
            finally {
                for (MailAccess access : accesses.values()) {
                    access.close(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyFor(Session session) {
        ConcurrentHashMap<Integer, MailAccess<IMailFolderStorage, IMailMessageStorage>> accesses = new ConcurrentHashMap<Integer, MailAccess<IMailFolderStorage, IMailMessageStorage>>(4, 0.9f, 1);
        try {
            for (CompositionSpace space : CompositionSpace.getRegistry(session).removeAllCompositionSpaces()) {
                MailPath mailPath;
                Queue<MailPath> cleanUps = space.getCleanUps();
                while ((mailPath = cleanUps.poll()) != null) {
                    MailAccess<IMailFolderStorage, IMailMessageStorage> access = (MailAccess<IMailFolderStorage, IMailMessageStorage>)accesses.get(mailPath.getAccountId());
                    if (null == access) {
                        try {
                            access = MailAccess.getNewInstance(session, mailPath.getAccountId());
                            access.connect(false);
                            accesses.put(mailPath.getAccountId(), access);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Could not obtain access for {}", (Object)mailPath.getAccountId(), (Object)e);
                        }
                    }
                    if (null == access) continue;
                    try {
                        access.getMessageStorage().deleteMessages(mailPath.getFolder(), new String[]{mailPath.getMailID()}, true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to delete {}", (Object)mailPath, (Object)e);
                    }
                }
            }
        }
        finally {
            for (MailAccess access : accesses.values()) {
                access.close(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroy(CompositionSpaceRegistry registry, Session session) {
        ConcurrentHashMap<Integer, MailAccess<IMailFolderStorage, IMailMessageStorage>> accesses = new ConcurrentHashMap<Integer, MailAccess<IMailFolderStorage, IMailMessageStorage>>(4, 0.9f, 1);
        try {
            for (CompositionSpace space : registry.removeAllCompositionSpaces()) {
                MailPath mailPath;
                Queue<MailPath> cleanUps = space.getCleanUps();
                while ((mailPath = cleanUps.poll()) != null) {
                    MailAccess<IMailFolderStorage, IMailMessageStorage> access = (MailAccess<IMailFolderStorage, IMailMessageStorage>)accesses.get(mailPath.getAccountId());
                    if (null == access) {
                        try {
                            access = MailAccess.getNewInstance(session, mailPath.getAccountId());
                            access.connect(false);
                            accesses.put(mailPath.getAccountId(), access);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Could not obtain access for {}", (Object)mailPath.getAccountId(), (Object)e);
                        }
                    }
                    if (null == access) continue;
                    try {
                        access.getMessageStorage().deleteMessages(mailPath.getFolder(), new String[]{mailPath.getMailID()}, true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to delete {}", (Object)mailPath, (Object)e);
                    }
                }
            }
        }
        finally {
            for (MailAccess access : accesses.values()) {
                access.close(false);
            }
        }
    }

    public static void applyCompositionSpace(String csid, Session session) throws OXException {
        CompositionSpaces.applyCompositionSpace(csid, session, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyCompositionSpace(String csid, Session session, MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> optMailAccess, boolean updateMailFlags) throws OXException {
        CompositionSpace space = CompositionSpace.optCompositionSpace(csid, session);
        if (null == space) {
            return;
        }
        ConcurrentHashMap<Integer, MailAccess<IMailFolderStorage, IMailMessageStorage>> accesses = new ConcurrentHashMap<Integer, MailAccess<IMailFolderStorage, IMailMessageStorage>>(4, 0.9f, 1);
        try {
            Queue<MailPath> draftEditsFor;
            MailAccess<IMailFolderStorage, IMailMessageStorage> access;
            Queue<MailPath> forwardsFor;
            final MailPath replyFor = space.getReplyFor();
            if (null != replyFor && !updateMailFlags) {
                if (null != optMailAccess && replyFor.getAccountId() == optMailAccess.getAccountId()) {
                    new SafeAction<Void>(){

                        @Override
                        Void doPerform(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) throws Exception {
                            mailAccess.getMessageStorage().updateMessageFlags(replyFor.getFolder(), new String[]{replyFor.getMailID()}, 1, true);
                            return null;
                        }
                    }.performSafe(optMailAccess);
                } else {
                    MailAccess access2 = (MailAccess)accesses.get(replyFor.getAccountId());
                    if (null == access2) {
                        access2 = MailAccess.getNewInstance(session, replyFor.getAccountId());
                        access2.connect(false);
                        accesses.put(replyFor.getAccountId(), access2);
                    }
                    new SafeAction<Void>(){

                        @Override
                        Void doPerform(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) throws Exception {
                            mailAccess.getMessageStorage().updateMessageFlags(replyFor.getFolder(), new String[]{replyFor.getMailID()}, 1, true);
                            return null;
                        }
                    }.performSafe(access2);
                }
            }
            if (null != (forwardsFor = space.getForwardsFor()) && !forwardsFor.isEmpty() && !updateMailFlags) {
                for (final MailPath mailPath : forwardsFor) {
                    if (null != optMailAccess && mailPath.getAccountId() == optMailAccess.getAccountId()) {
                        new SafeAction<Void>(){

                            @Override
                            Void doPerform(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) throws Exception {
                                mailAccess.getMessageStorage().updateMessageFlags(mailPath.getFolder(), new String[]{mailPath.getMailID()}, 256, true);
                                return null;
                            }
                        }.performSafe(optMailAccess);
                        continue;
                    }
                    access = (MailAccess<IMailFolderStorage, IMailMessageStorage>)accesses.get(mailPath.getAccountId());
                    if (null == access) {
                        access = MailAccess.getNewInstance(session, mailPath.getAccountId());
                        access.connect(false);
                        accesses.put(mailPath.getAccountId(), access);
                    }
                    new SafeAction<Void>(){

                        @Override
                        Void doPerform(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) throws Exception {
                            mailAccess.getMessageStorage().updateMessageFlags(mailPath.getFolder(), new String[]{mailPath.getMailID()}, 256, true);
                            return null;
                        }
                    }.performSafe(access);
                }
            }
            if (null != (draftEditsFor = space.getDraftEditsFor()) && !draftEditsFor.isEmpty()) {
                for (final MailPath mailPath : draftEditsFor) {
                    if (space.isMarkedAsReplyOrForward(mailPath)) continue;
                    if (null != optMailAccess && mailPath.getAccountId() == optMailAccess.getAccountId()) {
                        new SafeAction<Void>(){

                            @Override
                            Void doPerform(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) throws Exception {
                                mailAccess.getMessageStorage().deleteMessages(mailPath.getFolder(), new String[]{mailPath.getMailID()}, true);
                                return null;
                            }
                        }.performSafe(optMailAccess);
                        continue;
                    }
                    access = (MailAccess<IMailFolderStorage, IMailMessageStorage>)accesses.get(mailPath.getAccountId());
                    if (null == access) {
                        access = MailAccess.getNewInstance(session, mailPath.getAccountId());
                        access.connect(false);
                        accesses.put(mailPath.getAccountId(), access);
                    }
                    new SafeAction<Void>(){

                        @Override
                        Void doPerform(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) throws Exception {
                            mailAccess.getMessageStorage().deleteMessages(mailPath.getFolder(), new String[]{mailPath.getMailID()}, true);
                            return null;
                        }
                    }.performSafe(access);
                }
            }
        }
        finally {
            for (MailAccess access2 : accesses.values()) {
                access2.close(false);
            }
        }
    }

    public static MailPath optUnifiedInboxUID(MailPath mailPath, int unifiedMailId) {
        if (unifiedMailId <= 0 || null == mailPath || mailPath.getAccountId() != unifiedMailId) {
            return null;
        }
        return UnifiedInboxUID.extractPossibleNestedMailPath(mailPath.getStr());
    }

    private static abstract class SafeAction<V> {
        SafeAction() {
        }

        V performSafe(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) {
            try {
                return this.doPerform(mailAccess);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to perform action.", (Throwable)e);
                return null;
            }
        }

        abstract V doPerform(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> var1) throws Exception;
    }
}

