/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache;

import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public final class PooledMailAccess
implements Delayed {
    private final long timeoutStamp;
    private final MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess;

    public static PooledMailAccess valueFor(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess, long ttlMillis) {
        return new PooledMailAccess(mailAccess, ttlMillis);
    }

    private PooledMailAccess(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess, long ttlMillis) {
        this.timeoutStamp = System.currentTimeMillis() + ttlMillis;
        this.mailAccess = mailAccess;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return TimeUnit.MILLISECONDS.equals((Object)unit) ? this.timeoutStamp - System.currentTimeMillis() : unit.convert(this.timeoutStamp - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        long thisStamp = this.timeoutStamp;
        long otherStamp = ((PooledMailAccess)o).timeoutStamp;
        return thisStamp < otherStamp ? -1 : (thisStamp == otherStamp ? 0 : 1);
    }

    public MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> getMailAccess() {
        return this.mailAccess;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(32);
        builder.append("PooledMailAccess [timeoutStamp=").append(this.timeoutStamp).append(", ");
        if (this.mailAccess != null) {
            builder.append("mailAccess=").append(this.mailAccess);
        }
        builder.append(']');
        return builder.toString();
    }
}

