/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.caching.CacheService;
import com.openexchange.caching.events.CacheEvent;
import com.openexchange.caching.events.CacheEventService;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public final class MailSessionCache {
    public static final String REGION = "MailSessionCache";
    private static final Object SENDER = new Object(){

        public String toString() {
            return MailSessionCache.REGION;
        }
    };
    private final TIntObjectMap<ConcurrentMap<String, Object>> map = new TIntObjectHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MailSessionCache getInstance(Session session) {
        if (null == session) {
            return null;
        }
        String key = MailSessionParameterNames.getParamMainCache();
        MailSessionCache mailCache = null;
        try {
            mailCache = (MailSessionCache)session.getParameter(key);
        }
        catch (ClassCastException e) {
            mailCache = null;
            session.setParameter(key, null);
        }
        if (null == mailCache) {
            Lock lock = (Lock)session.getParameter(Session.PARAM_LOCK);
            if (null == lock) {
                lock = Session.EMPTY_LOCK;
            }
            lock.lock();
            try {
                mailCache = (MailSessionCache)session.getParameter(key);
                if (null == mailCache) {
                    mailCache = new MailSessionCache();
                    session.setParameter(key, (Object)mailCache);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return mailCache;
    }

    public static MailSessionCache optInstance(Session session) {
        if (null == session) {
            return null;
        }
        String key = MailSessionParameterNames.getParamMainCache();
        MailSessionCache mailCache = null;
        try {
            mailCache = (MailSessionCache)session.getParameter(key);
        }
        catch (ClassCastException e) {
            mailCache = null;
            session.setParameter(key, null);
        }
        return mailCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropInstance(Session session) {
        String key = MailSessionParameterNames.getParamMainCache();
        MailSessionCache mailCache = null;
        try {
            mailCache = (MailSessionCache)session.getParameter(key);
        }
        catch (ClassCastException e) {
            mailCache = null;
            session.setParameter(key, null);
            return;
        }
        if (null != mailCache) {
            Lock lock = (Lock)session.getParameter(Session.PARAM_LOCK);
            if (null == lock) {
                lock = Session.EMPTY_LOCK;
            }
            lock.lock();
            try {
                mailCache = (MailSessionCache)session.getParameter(key);
                if (null != mailCache) {
                    mailCache.clear();
                    session.setParameter(key, null);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static void clearInstance(Session session) {
        String key = MailSessionParameterNames.getParamMainCache();
        MailSessionCache mailCache = null;
        try {
            mailCache = (MailSessionCache)session.getParameter(key);
        }
        catch (ClassCastException e) {
            mailCache = null;
            session.setParameter(key, null);
            return;
        }
        if (null == mailCache) {
            return;
        }
        mailCache.clear();
    }

    public static void clearFor(int userId, int contextId) {
        MailSessionCache.clearFor(userId, contextId, true);
    }

    public static void clearFor(int userId, int contextId, boolean notify) {
        SessiondService sessiondService = (SessiondService)SessiondService.SERVICE_REFERENCE.get();
        if (null != sessiondService) {
            boolean somethingCleared = false;
            Collection sessions = sessiondService.getSessions(userId, contextId);
            for (Session session : sessions) {
                MailSessionCache mailSessionCache = MailSessionCache.optInstance(session);
                if (null == mailSessionCache) continue;
                mailSessionCache.clear();
                somethingCleared = true;
            }
            if (somethingCleared && notify) {
                MailSessionCache.fireInvalidateCacheEvent(userId, contextId);
            }
        }
    }

    private static void fireInvalidateCacheEvent(int userId, int contextId) {
        CacheEvent event;
        CacheEventService cacheEventService = ServerServiceRegistry.getInstance().getService(CacheEventService.class);
        if (null != cacheEventService && cacheEventService.getConfiguration().remoteInvalidationForPersonalFolders() && null != (event = MailSessionCache.newCacheEventFor(userId, contextId))) {
            cacheEventService.notify(SENDER, event, false);
        }
    }

    private static CacheEvent newCacheEventFor(int userId, int contextId) {
        CacheService service = ServerServiceRegistry.getInstance().getService(CacheService.class);
        return null == service ? null : CacheEvent.INVALIDATE((String)REGION, (String)Integer.toString(contextId), (Serializable)service.newCacheKey(contextId, userId));
    }

    public static void removeDefaultFolderInformationFrom(int accountId, int userId, int contextId) {
        SessiondService sessiondService = (SessiondService)SessiondService.SERVICE_REFERENCE.get();
        if (null != sessiondService) {
            Collection sessions = sessiondService.getSessions(userId, contextId);
            for (Session s : sessions) {
                MailSessionCache sessionCache = MailSessionCache.optInstance(s);
                if (null == sessionCache) continue;
                sessionCache.removeParameter(accountId, MailSessionParameterNames.getParamDefaultFolderChecked());
                sessionCache.removeParameter(accountId, MailSessionParameterNames.getParamDefaultFolderArray());
            }
        }
    }

    private MailSessionCache() {
    }

    public <T> T getParameter(int accountId, String parameterName) {
        ConcurrentMap accountMap = (ConcurrentMap)this.map.get(accountId);
        if (null == accountMap) {
            return null;
        }
        try {
            Object retval = accountMap.get(parameterName);
            return (T)retval;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public boolean containsParameter(int accountId, String parameterName) {
        ConcurrentMap accountMap = (ConcurrentMap)this.map.get(accountId);
        if (null == accountMap) {
            return false;
        }
        return accountMap.containsKey(parameterName);
    }

    public void putParameter(int accountId, String parameterName, Object parameterValue) {
        NonBlockingHashMap newInst;
        ConcurrentMap accountMap = (ConcurrentMap)this.map.get(accountId);
        if (null == accountMap && null == (accountMap = (ConcurrentMap)this.map.putIfAbsent(accountId, (Object)(newInst = new NonBlockingHashMap())))) {
            accountMap = newInst;
        }
        if (null == parameterValue) {
            accountMap.remove(parameterName);
        } else {
            accountMap.put(parameterName, parameterValue);
        }
    }

    public Object putParameterIfAbsent(int accountId, String parameterName, Object parameterValue) {
        NonBlockingHashMap newInst;
        ConcurrentMap accountMap = (ConcurrentMap)this.map.get(accountId);
        if (null == accountMap && null == (accountMap = (ConcurrentMap)this.map.putIfAbsent(accountId, (Object)(newInst = new NonBlockingHashMap())))) {
            accountMap = newInst;
        }
        if (null == parameterValue) {
            return accountMap.remove(parameterName);
        }
        return accountMap.putIfAbsent(parameterName, parameterValue);
    }

    public Object removeParameter(int accountId, String parameterName) {
        ConcurrentMap accountMap = (ConcurrentMap)this.map.get(accountId);
        if (null == accountMap) {
            return null;
        }
        return accountMap.remove(parameterName);
    }

    public void removeAccountParameters(int accountId) {
        ConcurrentMap removed = (ConcurrentMap)this.map.remove(accountId);
        if (null != removed) {
            removed.clear();
        }
    }

    public void clear() {
        this.map.clear();
    }
}

