/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

public final class FullnameArgument {
    private final int accountId;
    private final String fullName;
    private final int hash;

    public FullnameArgument(String fullName) {
        this(0, fullName);
    }

    public FullnameArgument(int accountId, String fullName) {
        this.accountId = accountId;
        this.fullName = fullName;
        int prime = 31;
        int result = prime * 1 + accountId;
        this.hash = result = prime * result + (fullName == null ? 0 : fullName.hashCode());
    }

    public int getAccountId() {
        return this.accountId;
    }

    public String getFullname() {
        return this.fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FullnameArgument)) {
            return false;
        }
        FullnameArgument other = (FullnameArgument)obj;
        if (this.accountId != other.accountId) {
            return false;
        }
        return !(this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName));
    }

    public String toString() {
        return new StringBuilder(32).append("Account-ID=").append(this.accountId).append(" Full-Name=").append(this.fullName).toString();
    }
}

