/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataBuilder;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.Dispatchers;
import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptions;
import com.openexchange.login.LoginRampUpService;
import com.openexchange.osgi.ExceptionUtils;
import com.openexchange.server.ServiceLookup;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.tools.session.ServerSession;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultAppSuiteLoginRampUp
implements LoginRampUpService {
    static final Logger LOG = LoggerFactory.getLogger(DefaultAppSuiteLoginRampUp.class);
    protected final ServiceLookup services;
    private static final RampUpKey[] KEYS = RampUpKey.values();

    protected DefaultAppSuiteLoginRampUp(ServiceLookup services) {
        this.services = services;
    }

    static void handleException(OXException e, String key) {
        if (OXExceptions.isCategory((Category)Category.CATEGORY_PERMISSION_DENIED, (OXException)e)) {
            LOG.debug("Permission error during {} ramp-up", (Object)key, (Object)e);
        } else {
            LOG.error("Error during {} ramp-up", (Object)key, (Object)e);
        }
    }

    static void handleException(Exception e, String key) {
        LOG.error("Error during {} ramp-up", (Object)key, (Object)e);
    }

    @Override
    public JSONObject getContribution(final ServerSession session, final AJAXRequestData loginRequest) throws OXException {
        int numberOfKeys = KEYS.length;
        ConcurrentHashMap<String, Future> rampUps = new ConcurrentHashMap<String, Future>(numberOfKeys);
        ThreadPoolService threads = (ThreadPoolService)this.services.getService(ThreadPoolService.class);
        final Dispatcher ox = (Dispatcher)this.services.getService(Dispatcher.class);
        rampUps.put(RampUpKey.FOLDER_LIST.key, threads.submit((Task)new AbstractTask<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object call() throws Exception {
                block7: {
                    AJAXRequestResult requestResult = null;
                    Throwable exc = null;
                    try {
                        JSONObject folderlist = new JSONObject(2);
                        AJAXRequestData requestData = AJAXRequestDataBuilder.request().session(session).module("folders").action("list").params("parent", "1", "tree", "0", "altNames", "true", "timezone", "UTC", "columns", "1,2,3,4,5,6,20,23,300,301,302,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,3010,3020,3030").format("json").build(loginRequest);
                        requestResult = ox.perform(requestData, null, session);
                        folderlist.put("1", requestResult.getResultObject());
                        JSONObject jSONObject = folderlist;
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                        return jSONObject;
                    }
                    catch (OXException x) {
                        exc = x;
                        DefaultAppSuiteLoginRampUp.handleException(x, RampUpKey.FOLDER_LIST.key);
                    }
                    catch (RuntimeException x2) {
                        exc = x2;
                        DefaultAppSuiteLoginRampUp.handleException(x2, RampUpKey.FOLDER_LIST.key);
                        break block7;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                    }
                }
                return null;
            }
        }));
        rampUps.put(RampUpKey.FOLDER.key, threads.submit((Task)new AbstractTask<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object call() throws Exception {
                JSONObject folder;
                block16: {
                    AJAXRequestData requestData;
                    Throwable exc;
                    AJAXRequestResult requestResult;
                    block15: {
                        if (null == session.getUserPermissionBits() || !session.getUserPermissionBits().hasWebMail()) {
                            return null;
                        }
                        folder = new JSONObject(3);
                        requestResult = null;
                        exc = null;
                        try {
                            requestData = AJAXRequestDataBuilder.request().session(session).module("folders").action("get").params("id", "1", "tree", "1", "altNames", "true", "timezone", "UTC").format("json").build(loginRequest);
                            requestResult = ox.perform(requestData, null, session);
                            folder.put("1", requestResult.getResultObject());
                            Dispatchers.signalDone(requestResult, (Exception)exc);
                        }
                        catch (OXException x) {
                            exc = x;
                            DefaultAppSuiteLoginRampUp.handleException(x, RampUpKey.FOLDER.key);
                        }
                        catch (RuntimeException x2) {
                            exc = x2;
                            DefaultAppSuiteLoginRampUp.handleException(x2, RampUpKey.FOLDER.key);
                            break block15;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            Dispatchers.signalDone(requestResult, (Exception)exc);
                        }
                    }
                    requestResult = null;
                    exc = null;
                    try {
                        requestData = AJAXRequestDataBuilder.request().session(session).module("folders").action("get").params("id", "default0/INBOX", "tree", "1", "altNames", "true", "timezone", "UTC").format("json").build(loginRequest);
                        requestResult = ox.perform(requestData, null, session);
                        folder.put("default0/INBOX", requestResult.getResultObject());
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                    }
                    catch (OXException x) {
                        exc = x;
                        DefaultAppSuiteLoginRampUp.handleException(x, RampUpKey.FOLDER.key);
                    }
                    catch (RuntimeException x3) {
                        exc = x3;
                        DefaultAppSuiteLoginRampUp.handleException(x3, RampUpKey.FOLDER.key);
                        break block16;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                    }
                }
                return folder;
            }
        }));
        rampUps.put(RampUpKey.JSLOBS.key, threads.submit((Task)new AbstractTask<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object call() throws Exception {
                block8: {
                    AJAXRequestResult requestResult = null;
                    Throwable exc = null;
                    try {
                        JSONObject jslobs = new JSONObject();
                        AJAXRequestData requestData = AJAXRequestDataBuilder.request().session(session).module("jslob").action("list").data(new JSONArray(Arrays.asList("io.ox/core", "io.ox/core/updates", "io.ox/mail", "io.ox/contacts", "io.ox/calendar", "io.ox/caldav", "io.ox/files", "io.ox/tours", "io.ox/mail/emoji", "io.ox/tasks", "io.ox/office")), "json").format("json").build(loginRequest);
                        requestResult = ox.perform(requestData, null, session);
                        JSONArray lobs = (JSONArray)requestResult.getResultObject();
                        int size = lobs.length();
                        for (int i = 0; i < size; ++i) {
                            JSONObject lob = lobs.getJSONObject(i);
                            jslobs.put(lob.getString("id"), (Object)lob);
                        }
                        JSONObject jSONObject = jslobs;
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                        return jSONObject;
                    }
                    catch (OXException x) {
                        exc = x;
                        DefaultAppSuiteLoginRampUp.handleException(x, RampUpKey.JSLOBS.key);
                    }
                    catch (RuntimeException x2) {
                        exc = x2;
                        DefaultAppSuiteLoginRampUp.handleException(x2, RampUpKey.JSLOBS.key);
                        break block8;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                    }
                }
                return null;
            }
        }));
        rampUps.put(RampUpKey.SERVER_CONFIG.key, threads.submit((Task)new AbstractTask<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object call() throws Exception {
                block7: {
                    AJAXRequestResult requestResult = null;
                    Throwable exc = null;
                    try {
                        AJAXRequestData requestData = AJAXRequestDataBuilder.request().session(session).module("apps/manifests").action("config").format("json").hostname(loginRequest.getHostname()).build(loginRequest);
                        requestResult = ox.perform(requestData, null, session);
                        Object object = requestResult.getResultObject();
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                        return object;
                    }
                    catch (OXException x) {
                        exc = x;
                        DefaultAppSuiteLoginRampUp.handleException(x, RampUpKey.SERVER_CONFIG.key);
                    }
                    catch (RuntimeException x2) {
                        exc = x2;
                        DefaultAppSuiteLoginRampUp.handleException(x2, RampUpKey.SERVER_CONFIG.key);
                        break block7;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                    }
                }
                return null;
            }
        }));
        rampUps.put(RampUpKey.OAUTH.key, threads.submit((Task)new AbstractTask<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object call() throws Exception {
                AJAXRequestData requestData;
                Throwable exc;
                AJAXRequestResult requestResult;
                JSONObject oauth;
                block22: {
                    if (session.isAnonymous() || session.getUser().isGuest()) {
                        return null;
                    }
                    oauth = new JSONObject(3);
                    requestResult = null;
                    exc = null;
                    try {
                        requestData = AJAXRequestDataBuilder.request().session(session).module("oauth/services").action("all").format("json").build(loginRequest);
                        requestResult = ox.perform(requestData, null, session);
                        oauth.put("services", requestResult.getResultObject());
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                    }
                    catch (OXException x) {
                        exc = x;
                        DefaultAppSuiteLoginRampUp.handleException(x, RampUpKey.OAUTH.key);
                    }
                    catch (RuntimeException x2) {
                        exc = x2;
                        DefaultAppSuiteLoginRampUp.handleException(x2, RampUpKey.OAUTH.key);
                        break block22;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                    }
                }
                requestResult = null;
                exc = null;
                try {
                    requestData = AJAXRequestDataBuilder.request().session(session).module("oauth/accounts").action("all").format("json").build(loginRequest);
                    requestResult = ox.perform(requestData, null, session);
                    oauth.put("accounts", requestResult.getResultObject());
                }
                catch (OXException x) {
                    exc = x;
                    DefaultAppSuiteLoginRampUp.handleException(x, RampUpKey.OAUTH.key);
                }
                catch (RuntimeException x) {
                    exc = x;
                    DefaultAppSuiteLoginRampUp.handleException(x, RampUpKey.OAUTH.key);
                }
                finally {
                    Dispatchers.signalDone(requestResult, (Exception)exc);
                }
                requestResult = null;
                exc = null;
                try {
                    requestData = AJAXRequestDataBuilder.request().session(session).module("recovery/secret").action("check").format("json").build(loginRequest);
                    requestResult = ox.perform(requestData, null, session);
                    oauth.put("secretCheck", requestResult.getResultObject());
                }
                catch (OXException x) {
                    exc = x;
                    DefaultAppSuiteLoginRampUp.handleException(x, RampUpKey.OAUTH.key);
                }
                catch (RuntimeException x) {
                    exc = x;
                    DefaultAppSuiteLoginRampUp.handleException(x, RampUpKey.OAUTH.key);
                }
                finally {
                    Dispatchers.signalDone(requestResult, (Exception)exc);
                }
                return oauth;
            }
        }));
        rampUps.put(RampUpKey.USER.key, threads.submit((Task)new AbstractTask<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object call() throws Exception {
                block7: {
                    AJAXRequestResult requestResult = null;
                    Throwable exc = null;
                    try {
                        AJAXRequestData requestData = AJAXRequestDataBuilder.request().session(session).module("user").action("get").params("timezone", "utc", "id", Integer.toString(session.getUserId())).format("json").build(loginRequest);
                        requestResult = ox.perform(requestData, null, session);
                        Object object = requestResult.getResultObject();
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                        return object;
                    }
                    catch (OXException x) {
                        exc = x;
                        DefaultAppSuiteLoginRampUp.handleException(x, RampUpKey.USER.key);
                    }
                    catch (RuntimeException x2) {
                        exc = x2;
                        DefaultAppSuiteLoginRampUp.handleException(x2, RampUpKey.USER.key);
                        break block7;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                    }
                }
                return null;
            }
        }));
        rampUps.put(RampUpKey.ACCOUNTS.key, threads.submit((Task)new AbstractTask<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object call() throws Exception {
                block7: {
                    AJAXRequestResult requestResult = null;
                    Throwable exc = null;
                    try {
                        AJAXRequestData requestData = AJAXRequestDataBuilder.request().session(session).module("account").action("all").format("json").params("columns", "all").build(loginRequest);
                        requestResult = ox.perform(requestData, null, session);
                        Object object = requestResult.getResultObject();
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                        return object;
                    }
                    catch (OXException x) {
                        exc = x;
                        DefaultAppSuiteLoginRampUp.handleException(x, RampUpKey.ACCOUNTS.key);
                    }
                    catch (RuntimeException x2) {
                        exc = x2;
                        DefaultAppSuiteLoginRampUp.handleException(x2, RampUpKey.ACCOUNTS.key);
                        break block7;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        Dispatchers.signalDone(requestResult, (Exception)exc);
                    }
                }
                return null;
            }
        }));
        try {
            JSONObject jo = new JSONObject(numberOfKeys);
            for (RampUpKey rampUpKey : KEYS) {
                Object value = ((Future)rampUps.get(rampUpKey.key)).get();
                jo.put(rampUpKey.key, JSONCoercion.coerceToJSON(value));
            }
            return jo;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            Logger logger = LoggerFactory.getLogger(DefaultAppSuiteLoginRampUp.class);
            logger.warn("Failed ramp-up", t);
            return new JSONObject();
        }
    }

    private static enum RampUpKey {
        SERVER_CONFIG("serverConfig"),
        JSLOBS("jslobs"),
        OAUTH("oauth"),
        FOLDER("folder"),
        FOLDER_LIST("folderlist"),
        USER("user"),
        ACCOUNTS("accounts");

        final String key;

        private RampUpKey(String key) {
            this.key = key;
        }
    }
}

