/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.json.cache.impl.osgi;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.json.cache.impl.osgi.JsonCacheAddInProgressFieldTask;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public final class JsonCacheAddOtherFieldsTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[]{JsonCacheAddInProgressFieldTask.class.getName()};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = dbService.getForUpdateTask(cid);
        try {
            DBUtils.startTransaction(con);
            Tools.checkAndAddColumns(con, "jsonCache", new Column("inProgressSince", "bigint(64) DEFAULT NULL"));
            Tools.checkAndAddColumns(con, "jsonCache", new Column("lastUpdate", "bigint(64) DEFAULT NULL"));
            Tools.checkAndAddColumns(con, "jsonCache", new Column("took", "bigint(64) DEFAULT 0"));
            Tools.checkAndAddColumns(con, "jsonCache", new Column("size", "bigint(64) DEFAULT 0"));
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }
}

