/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.i18n.tools.TemplateReplacement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AbstractMultipleDateReplacement
implements TemplateReplacement {
    private static final String PAT_ZONE = ", z";
    protected Date[] dates;
    protected boolean changed;
    protected DateFormat dateFormat;
    protected Locale locale;
    protected TimeZone timeZone;

    protected AbstractMultipleDateReplacement(Date[] dates) {
        this(dates, null, null);
    }

    protected AbstractMultipleDateReplacement(Date[] dates, Locale locale, TimeZone timeZone) {
        if (dates == null) {
            this.dates = null;
        } else {
            this.dates = new Date[dates.length];
            for (int i = 0; i < dates.length; ++i) {
                this.dates[i] = (Date)dates[i].clone();
            }
        }
        DateFormat dateFormat = this.dateFormat = locale == null ? DateFormat.getDateInstance(2, Locale.ENGLISH) : DateFormat.getDateInstance(2, locale);
        if (timeZone != null) {
            if (this.dateFormat instanceof SimpleDateFormat) {
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.dateFormat;
                String pattern = simpleDateFormat.toPattern();
                simpleDateFormat.applyPattern(new StringBuilder(pattern.length() + 3).append(pattern).append(PAT_ZONE).toString());
            }
            this.timeZone = timeZone;
            this.dateFormat.setTimeZone(timeZone);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractMultipleDateReplacement clone = (AbstractMultipleDateReplacement)super.clone();
        if (this.dates == null) {
            clone.dates = null;
        } else {
            clone.dates = new Date[this.dates.length];
            for (int i = 0; i < this.dates.length; ++i) {
                clone.dates[i] = (Date)this.dates[i].clone();
            }
        }
        clone.dateFormat = (DateFormat)(this.dateFormat == null ? null : this.dateFormat.clone());
        clone.locale = (Locale)(this.locale == null ? null : this.locale.clone());
        clone.timeZone = (TimeZone)(this.timeZone == null ? null : this.timeZone.clone());
        return clone;
    }

    @Override
    public TemplateReplacement getClone() throws CloneNotSupportedException {
        return (TemplateReplacement)this.clone();
    }

    @Override
    public final boolean changed() {
        return this.changed;
    }

    @Override
    public boolean relevantChange() {
        return this.changed();
    }

    @Override
    public final TemplateReplacement setChanged(boolean changed) {
        this.changed = changed;
        return this;
    }

    @Override
    public String getReplacement() {
        if (this.dates == null || this.dates.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(this.dates.length << 4);
        builder.append(this.dateFormat.format(this.dates[0]));
        for (int i = 1; i < this.dates.length; ++i) {
            builder.append(", ").append(this.dateFormat.format(this.dates[i]));
        }
        return builder.toString();
    }

    @Override
    public final TemplateReplacement setTimeZone(TimeZone timeZone) {
        this.applyTimeZone(timeZone);
        return this;
    }

    @Override
    public final TemplateReplacement setLocale(Locale locale) {
        this.applyLocale(locale);
        return this;
    }

    @Override
    public boolean merge(TemplateReplacement other) {
        if (!AbstractMultipleDateReplacement.class.isInstance(other)) {
            return false;
        }
        if (!this.getToken().equals((Object)other.getToken())) {
            return false;
        }
        if (!other.changed()) {
            return false;
        }
        AbstractMultipleDateReplacement o = (AbstractMultipleDateReplacement)other;
        Date[] oDates = o.dates;
        if (oDates == null) {
            this.dates = null;
        } else {
            this.dates = new Date[oDates.length];
            for (int i = 0; i < oDates.length; ++i) {
                this.dates[i] = (Date)oDates[i].clone();
            }
        }
        this.changed = true;
        return true;
    }

    private void applyLocale(Locale locale) {
        if (locale == null || locale.equals(this.locale)) {
            return;
        }
        this.locale = locale;
        this.dateFormat = DateFormat.getDateInstance(2, locale);
        if (this.timeZone != null) {
            this.dateFormat.setTimeZone(this.timeZone);
        }
    }

    private void applyTimeZone(TimeZone timeZone) {
        if (timeZone == null || timeZone.equals(this.timeZone)) {
            return;
        }
        this.timeZone = timeZone;
        this.dateFormat.setTimeZone(timeZone);
    }
}

