/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tools;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.SchemaStore;
import com.openexchange.groupware.update.SchemaUpdateState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.groupware.update.internal.DynamicList;
import com.openexchange.groupware.update.internal.UpdateExecutor;
import com.openexchange.groupware.update.internal.UpdateProcess;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class UpdateTaskToolkit {
    private static final Object LOCK = new Object();
    private static final String SQL_SELECT_SCHEMAS = "SELECT db_schema,cid FROM context_server2db_pool";

    private UpdateTaskToolkit() {
    }

    public static void forceUpdateTask(String className, String schemaName) throws OXException {
        UpdateTaskToolkit.forceUpdateTask(className, UpdateTaskToolkit.getContextIdBySchema(schemaName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceUpdateTask(String className, int contextId) throws OXException {
        Object object = LOCK;
        synchronized (object) {
            UpdateTaskToolkit.forceUpdateTask0(UpdateTaskToolkit.getUpdateTask(className), contextId);
        }
    }

    private static void forceUpdateTask0(UpdateTaskV2 task, int contextId) throws OXException {
        ArrayList<UpdateTaskV2> taskList = new ArrayList<UpdateTaskV2>(1);
        taskList.add(task);
        new UpdateExecutor(UpdateTaskToolkit.getSchema(contextId), contextId, taskList).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceUpdateTaskOnAllSchemas(String className) throws OXException {
        Object object = LOCK;
        synchronized (object) {
            UpdateTaskV2 updateTask = UpdateTaskToolkit.getUpdateTask(className);
            Map<String, Set<Integer>> map = UpdateTaskToolkit.getSchemasAndContexts();
            for (Set<Integer> set : map.values()) {
                if (set.isEmpty()) continue;
                UpdateTaskToolkit.forceUpdateTask0(updateTask, set.iterator().next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUpdateOnAllSchemas() throws OXException {
        Object object = LOCK;
        synchronized (object) {
            Map<String, Set<Integer>> map = UpdateTaskToolkit.getSchemasAndContexts();
            for (Set<Integer> set : map.values()) {
                if (set.isEmpty()) continue;
                int contextId = set.iterator().next();
                new UpdateProcess(contextId).run();
            }
        }
    }

    private static Map<String, Set<Integer>> getSchemasAndContexts() throws OXException {
        HashMap<String, Set<Integer>> hashMap;
        Connection con = Database.get(false);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(SQL_SELECT_SCHEMAS);
            rs = stmt.executeQuery();
            HashMap<String, Set<Integer>> schemasAndContexts = new HashMap<String, Set<Integer>>();
            while (rs.next()) {
                String schemaName = rs.getString(1);
                int contextId = rs.getInt(2);
                HashSet<Integer> contextIds = (HashSet<Integer>)schemasAndContexts.get(schemaName);
                if (null == contextIds) {
                    contextIds = new HashSet<Integer>();
                    schemasAndContexts.put(schemaName, contextIds);
                }
                contextIds.add(contextId);
            }
            hashMap = schemasAndContexts;
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(false, con);
        return hashMap;
    }

    public static int getContextIdBySchema(String schemaName) throws OXException {
        Map<String, Set<Integer>> map = UpdateTaskToolkit.getSchemasAndContexts();
        Set<Integer> set = map.get(schemaName);
        if (null == set) {
            throw UpdateExceptionCodes.UNKNOWN_SCHEMA.create(schemaName);
        }
        return set.iterator().next();
    }

    private static UpdateTaskV2 getUpdateTask(String className) throws OXException {
        List<UpdateTaskV2> taskList = DynamicList.getInstance().getTaskList();
        for (UpdateTaskV2 task : taskList) {
            if (!task.getClass().getName().equals(className)) continue;
            return task;
        }
        throw UpdateExceptionCodes.UNKNOWN_TASK.create(className);
    }

    private static SchemaUpdateState getSchema(int contextId) throws OXException {
        return SchemaStore.getInstance().getSchema(contextId);
    }
}

