/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tools;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.ExecutedTask;
import com.openexchange.groupware.update.SchemaStore;
import com.openexchange.groupware.update.TaskInfo;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.internal.UpdateProcess;
import com.openexchange.groupware.update.tools.UpdateTaskToolkit;
import com.openexchange.groupware.update.tools.Utility;
import com.openexchange.java.Autoboxing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Queue;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpdateTaskMBean
implements DynamicMBean {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateTaskMBean.class);
    private final MBeanInfo mbeanInfo;
    private final String[] taskTypeNames = new String[]{"taskName", "successful", "lastModified"};
    private CompositeType taskType;
    private TabularType taskListType;

    public UpdateTaskMBean() {
        this.mbeanInfo = this.buildMBeanInfo();
    }

    private MBeanInfo buildMBeanInfo() {
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>(6);
        MBeanParameterInfo[] tparams = new MBeanParameterInfo[]{new MBeanParameterInfo("id", "java.lang.String", "A valid context identifier contained in target schema or a schema name")};
        operations.add(new MBeanOperationInfo("runUpdate", "Runs the schema's update.", tparams, "void", 1));
        MBeanParameterInfo[] forceParams = new MBeanParameterInfo[]{new MBeanParameterInfo("className", "java.lang.String", "The update task's class name"), new MBeanParameterInfo("id", "java.lang.String", "A valid context identifier contained in target schema or a schema name")};
        operations.add(new MBeanOperationInfo("force", "Forces re-run of given update task.", forceParams, "void", 1));
        MBeanParameterInfo[] forceAllParams = new MBeanParameterInfo[]{new MBeanParameterInfo("className", "java.lang.String", "The update task's class name")};
        operations.add(new MBeanOperationInfo("forceOnAllSchemas", "Forces re-run of given update task on all schemas.", forceAllParams, "void", 1));
        operations.add(new MBeanOperationInfo("runAllUpdate", "Runs the update on all schemas.", null, "void", 1));
        try {
            String[] taskTypeDescriptions = new String[]{"Class name of the update task", "Wether it is executed successfully or not.", "Last task execution time stamp."};
            OpenType[] taskTypes = new OpenType[]{SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.DATE};
            this.taskType = new CompositeType("Update task", "Executed update task", this.taskTypeNames, taskTypeDescriptions, taskTypes);
            this.taskListType = new TabularType("UpdateTask list", "List of update tasks.", this.taskType, new String[]{"taskName"});
            MBeanParameterInfo[] listExecutedTasks = new MBeanParameterInfo[]{new MBeanParameterInfo("schema", "java.lang.String", "Name of a schema that update tasks should be listed.")};
            operations.add(new MBeanOperationInfo("listExecutedTasks", "Lists executed update tasks of a schema.", listExecutedTasks, "javax.management.openmbean.TabularData", 0));
        }
        catch (OpenDataException e) {
            LOG.error("", (Throwable)e);
        }
        return new MBeanInfo(UpdateTaskMBean.class.getName(), "Update task toolkit", null, null, operations.toArray(new MBeanOperationInfo[operations.size()]), null);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException {
        throw new AttributeNotFoundException("No attribute can be obtained in this MBean");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return new AttributeList();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName.equals("runUpdate")) {
            try {
                Object param = params[0];
                if (param instanceof Integer) {
                    new UpdateProcess((Integer)param).run();
                } else {
                    String sParam = param.toString();
                    int parsed = Utility.parsePositiveInt(sParam);
                    UpdateProcess updateProcess = parsed >= 0 ? new UpdateProcess(parsed, true) : new UpdateProcess(UpdateTaskToolkit.getContextIdBySchema(param.toString()), true);
                    updateProcess.run();
                    Queue<TaskInfo> failures = updateProcess.getFailures();
                    if (null != failures && !failures.isEmpty()) {
                        StringBuilder sb = new StringBuilder("The following update task(s) failed: \\R");
                        boolean first = true;
                        for (TaskInfo taskInfo : failures) {
                            if (first) {
                                first = false;
                            } else {
                                sb.append("\\R");
                            }
                            sb.append(' ').append(taskInfo.getTaskName()).append(" (schema=").append(taskInfo.getSchema()).append(')');
                        }
                        return sb.toString();
                    }
                }
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                Exception wrapMe = new Exception(e.getMessage());
                throw new MBeanException(wrapMe);
            }
            catch (RuntimeException e) {
                LOG.error("", (Throwable)e);
                throw e;
            }
            catch (Error e) {
                LOG.error("", (Throwable)e);
                throw e;
            }
            return null;
        }
        if (actionName.equals("force")) {
            try {
                Object secParam = params[1];
                if (secParam instanceof Integer) {
                    UpdateTaskToolkit.forceUpdateTask((String)params[0], (Integer)secParam);
                } else {
                    String sParam = secParam.toString();
                    int parsed = Utility.parsePositiveInt(sParam);
                    if (parsed >= 0) {
                        UpdateTaskToolkit.forceUpdateTask((String)params[0], parsed);
                    } else {
                        UpdateTaskToolkit.forceUpdateTask((String)params[0], sParam);
                    }
                }
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                Exception wrapMe = new Exception(e.getMessage());
                throw new MBeanException(wrapMe);
            }
            catch (RuntimeException e) {
                LOG.error("", (Throwable)e);
                throw e;
            }
            catch (Error e) {
                LOG.error("", (Throwable)e);
                throw e;
            }
            return null;
        }
        if (actionName.equals("forceOnAllSchemas")) {
            try {
                UpdateTaskToolkit.forceUpdateTaskOnAllSchemas((String)params[0]);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                Exception wrapMe = new Exception(e.getMessage());
                throw new MBeanException(wrapMe);
            }
            catch (RuntimeException e) {
                LOG.error("", (Throwable)e);
                throw e;
            }
            catch (Error e) {
                LOG.error("", (Throwable)e);
                throw e;
            }
            return null;
        }
        if (actionName.equals("listExecutedTasks")) {
            try {
                return this.getExecutedTasksList(params[0].toString());
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                throw new MBeanException(new Exception(e.getMessage()), e.getMessage());
            }
            catch (RuntimeException e) {
                LOG.error("", (Throwable)e);
                throw e;
            }
            catch (Error e) {
                LOG.error("", (Throwable)e);
                throw e;
            }
        }
        if (actionName.equals("runAllUpdate")) {
            try {
                UpdateTaskToolkit.runUpdateOnAllSchemas();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                Exception wrapMe = new Exception(e.getMessage());
                throw new MBeanException(wrapMe);
            }
            catch (RuntimeException e) {
                LOG.error("", (Throwable)e);
                throw e;
            }
            catch (Error e) {
                LOG.error("", (Throwable)e);
                throw e;
            }
            return null;
        }
        ReflectionException e = new ReflectionException(new NoSuchMethodException(actionName));
        LOG.error("", (Throwable)e);
        throw e;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException {
        throw new AttributeNotFoundException("No attribute can be set in this MBean");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    private TabularDataSupport getExecutedTasksList(String schemaName) throws OXException {
        TabularDataSupport retval;
        SchemaStore store = SchemaStore.getInstance();
        try {
            int contextId = UpdateTaskToolkit.getContextIdBySchema(schemaName);
            int poolId = Database.resolvePool(contextId, true);
            Object[] tasks2 = store.getExecutedTasks(poolId, schemaName);
            if (null == tasks2) {
                tasks2 = new ExecutedTask[]{};
            }
            Arrays.sort(tasks2);
            retval = new TabularDataSupport(this.taskListType, tasks2.length, 1.0f);
            for (Object task : tasks2) {
                CompositeDataSupport data = new CompositeDataSupport(this.taskType, this.taskTypeNames, new Object[]{task.getTaskName(), Autoboxing.B((boolean)task.isSuccessful()), task.getLastModified()});
                retval.put(data);
            }
        }
        catch (OpenDataException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        return retval;
    }
}

