/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks.objectpermission;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.objectpermission.ObjectPermissionCreateTableService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ObjectPermissionCreateTableTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class, true);
        Connection writeCon = dbService.getForUpdateTask(contextId);
        PreparedStatement stmt = null;
        try {
            ObjectPermissionCreateTableService tmp = new ObjectPermissionCreateTableService();
            String createStmt = tmp.getCreateStatements()[0];
            String tableName = tmp.tablesToCreate()[0];
            if (!DBUtils.tableExists(writeCon, tableName)) {
                stmt = writeCon.prepareStatement(createStmt);
                stmt.executeUpdate();
                DBUtils.closeSQLStuff(null, stmt);
                stmt = null;
            }
            createStmt = tmp.getCreateStatements()[1];
            tableName = tmp.tablesToCreate()[1];
            tmp = null;
            if (!DBUtils.tableExists(writeCon, tableName)) {
                stmt = writeCon.prepareStatement(createStmt);
                stmt.executeUpdate();
                DBUtils.closeSQLStuff(null, stmt);
                stmt = null;
            }
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                catch (RuntimeException e2) {
                    throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                dbService.backForUpdateTask(contextId, writeCon);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
        dbService.backForUpdateTask(contextId, writeCon);
    }
}

