/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.Release781UpdateTask;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public final class UserSettingMediumTextTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[]{Release781UpdateTask.class.getName()};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = dbService.getForUpdateTask(cid);
        boolean rollback = false;
        try {
            DBUtils.startTransaction(con);
            rollback = true;
            String typeName = Tools.getColumnTypeName(con, "user_setting", "value");
            if (!"MEDIUMTEXT".equalsIgnoreCase(typeName)) {
                Column column = new Column("value", "MEDIUMTEXT COLLATE utf8_unicode_ci");
                Tools.modifyColumns(con, "user_setting", column);
            }
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }
}

