/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.PrgLinksAddUuidUpdateTask;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

public class PrgLinksAddPrimaryKeyUpdateTask
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        Connection con = Database.getNoTimeout(cid, true);
        Column column = new Column("uuid", "BINARY(16) NOT NULL");
        try {
            con.setAutoCommit(false);
            Tools.modifyColumns(con, "prg_links", column);
            Tools.createPrimaryKeyIfAbsent(con, "prg_links", new String[]{"cid", column.name});
            this.setUUID(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{PrgLinksAddUuidUpdateTask.class.getName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setUUID(Connection con) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT firstid, firstmodule, firstfolder, secondid, secondmodule, secondfolder, cid, last_modified, created_by FROM prg_links WHERE uuid IS NULL FOR UPDATE");
            rs = stmt.executeQuery();
            while (rs.next()) {
                PreparedStatement stmt2 = null;
                try {
                    StringBuilder sb = new StringBuilder();
                    sb.append("UPDATE prg_links SET uuid = ? WHERE firstid ");
                    int oldPos = 1;
                    int firstid = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND firstmodule ");
                    int firstmodule = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND firstfolder ");
                    int firstfolder = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND secondid ");
                    int secondid = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND secondmodule ");
                    int secondmodule = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND secondfolder ");
                    int secondfolder = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND cid ");
                    int cid = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND last_modified ");
                    long lastModified = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    sb.append("AND created_by ");
                    int createdBy = rs.getInt(oldPos++);
                    if (rs.wasNull()) {
                        sb.append("IS ? ");
                    } else {
                        sb.append("= ? ");
                    }
                    stmt2 = con.prepareStatement(sb.toString());
                    int newPos = 1;
                    UUID uuid = UUID.randomUUID();
                    stmt2.setBytes(newPos++, UUIDs.toByteArray((UUID)uuid));
                    stmt2.setInt(newPos++, firstid);
                    stmt2.setInt(newPos++, firstmodule);
                    stmt2.setInt(newPos++, firstfolder);
                    stmt2.setInt(newPos++, secondid);
                    stmt2.setInt(newPos++, secondmodule);
                    stmt2.setInt(newPos++, secondfolder);
                    stmt2.setInt(newPos++, cid);
                    stmt2.setLong(newPos++, lastModified);
                    stmt2.setInt(newPos++, createdBy);
                    stmt2.execute();
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(stmt2);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(stmt2);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }
}

