/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.tasks.MakeUUIDPrimaryForDListTables;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class MakeUUIDPrimaryForDListTablesV2
extends MakeUUIDPrimaryForDListTables {
    @Override
    public void perform(PerformParameters params) throws OXException {
        super.perform(params);
        Connection connection = Database.getNoTimeout(params.getContextId(), true);
        try {
            DBUtils.startTransaction(connection);
            Tools.modifyColumns(connection, "prg_dlist", new Column("cid", "INT4 NOT NULL"));
            connection.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(connection);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(connection);
            Database.backNoTimeout(params.getContextId(), true, connection);
        }
    }
}

