/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.Databases;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.infostore.database.impl.versioncontrol.VersionControlResult;
import com.openexchange.groupware.infostore.database.impl.versioncontrol.VersionControlUtil;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.java.Reference;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public final class FolderCorrectOwnerTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BLOCKING);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(PerformParameters params) throws OXException {
        log = LoggerFactory.getLogger(FolderCorrectOwnerTask.class);
        log.info("Performing update task {}", (Object)FolderCorrectOwnerTask.class.getSimpleName());
        con = Database.getNoTimeout(params.getContextId(), true);
        rollback = false;
        resultMaps = new LinkedHashMap<K, V>();
        try {
            Databases.startTransaction((Connection)con);
            rollback = true;
            users = this.getUsers(con);
            params.getProgressState().setTotal(users.size());
            num = 1;
            for (int[] user : users) {
                userId = user[1];
                trashFolders = this.getTrashFoldersToCheck(userId, contextId = user[0], con);
                if (null != trashFolders && !trashFolders.isEmpty()) {
                    conn = con;
                    ref = new Reference();
                    trashFolders.forEachEntry(new TIntIntProcedure(){

                        public boolean execute(int folderId, int oldOwner) {
                            try {
                                FolderCorrectOwnerTask.this.adjustTrashOwnershipFor(folderId, oldOwner, resultMaps, userId, contextId, conn);
                                return true;
                            }
                            catch (OXException e) {
                                ref.setValue((Object)e);
                            }
                            catch (SQLException e) {
                                ref.setValue((Object)UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage()));
                            }
                            catch (RuntimeException e) {
                                ref.setValue((Object)UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage()));
                            }
                            return false;
                        }
                    });
                }
                if (num % 10 == 0) {
                    params.getProgressState().setState(num - 1);
                }
                ++num;
            }
            con.commit();
            rollback = false;
            if (!rollback) ** GOTO lbl72
            ** GOTO lbl54
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, new Object[]{e.getMessage()});
                catch (RuntimeException e) {
                    throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, new Object[]{e.getMessage()});
                }
            }
            catch (Throwable var17_23) {
                block19: {
                    if (rollback) {
                        Databases.rollback((Connection)con);
                        Databases.autocommit((Connection)con);
                        for (Map.Entry<K, V> entry : resultMaps.entrySet()) {
                            contextId = (Integer)entry.getKey();
                            ctx = new ContextImpl(contextId);
                            for (Map resultMap : (List)entry.getValue()) {
                                for (Map.Entry<K, V> documentEntry : resultMap.entrySet()) {
                                    documentId = (Integer)documentEntry.getKey();
                                    versionInfo = (List)documentEntry.getValue();
                                    try {
                                        VersionControlUtil.restoreVersionControl(Collections.singletonMap(documentId, versionInfo), ctx, con);
                                    }
                                    catch (Exception e) {
                                        log.error("Failed to restore InfoStore/Drive files for document {} in context {}", new Object[]{documentId, contextId, e});
                                    }
                                }
                            }
                        }
                    }
                    break block19;
lbl54:
                    // 1 sources

                    Databases.rollback((Connection)con);
                    Databases.autocommit((Connection)con);
                    for (Map.Entry<K, V> entry : resultMaps.entrySet()) {
                        contextId = (Integer)entry.getKey();
                        ctx = new ContextImpl(contextId);
                        for (Map resultMap : (List)entry.getValue()) {
                            for (Map.Entry<K, V> documentEntry : resultMap.entrySet()) {
                                documentId = (Integer)documentEntry.getKey();
                                versionInfo = (List)documentEntry.getValue();
                                try {
                                    VersionControlUtil.restoreVersionControl(Collections.singletonMap(documentId, versionInfo), ctx, con);
                                }
                                catch (Exception e) {
                                    log.error("Failed to restore InfoStore/Drive files for document {} in context {}", new Object[]{documentId, contextId, e});
                                }
                            }
                        }
                    }
lbl72:
                    // 2 sources

                    Databases.autocommit((Connection)con);
                    Database.backNoTimeout(params.getContextId(), true, con);
                    log.info("{} successfully performed.", (Object)FolderCorrectOwnerTask.class.getSimpleName());
                    return;
                }
                Databases.autocommit((Connection)con);
                Database.backNoTimeout(params.getContextId(), true, con);
                throw var17_23;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<int[]> getUsers(Connection con) throws SQLException {
        LinkedList<int[]> linkedList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT cid, id FROM user ORDER BY cid, id");
            rs = stmt.executeQuery();
            LinkedList<int[]> users = new LinkedList<int[]>();
            while (rs.next()) {
                users.add(new int[]{rs.getInt(1), rs.getInt(2)});
            }
            linkedList = users;
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TIntIntMap getTrashFoldersToCheck(int userId, int contextId, Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block3: {
            TIntIntMap tIntIntMap;
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid=? AND type=? AND default_flag=1 AND created_from=?");
                stmt.setInt(1, contextId);
                stmt.setInt(2, 16);
                stmt.setInt(3, userId);
                rs = stmt.executeQuery();
                if (rs.next()) break block3;
                tIntIntMap = null;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            return tIntIntMap;
        }
        int trashId = rs.getInt(1);
        DBUtils.closeSQLStuff(rs, stmt);
        rs = null;
        stmt = null;
        TIntIntHashMap folderId2Owner = new TIntIntHashMap();
        this.collectTrashFolders(trashId, (TIntIntMap)folderId2Owner, userId, contextId, con);
        TIntIntHashMap tIntIntHashMap = folderId2Owner;
        DBUtils.closeSQLStuff(rs, stmt);
        return tIntIntHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectTrashFolders(int parentTrashId, TIntIntMap folderId2Owner, int userId, int contextId, Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block5: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT fuid, created_from FROM oxfolder_tree WHERE cid=? AND parent=?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, parentTrashId);
            rs = stmt.executeQuery();
            if (rs.next()) break block5;
            DBUtils.closeSQLStuff(rs, stmt);
            return;
        }
        try {
            TIntArrayList children = new TIntArrayList(8);
            do {
                int subfolderId;
                if (folderId2Owner.containsKey(subfolderId = rs.getInt(1))) continue;
                children.add(subfolderId);
                int createdFrom = rs.getInt(2);
                if (createdFrom == userId) continue;
                folderId2Owner.put(subfolderId, createdFrom);
            } while (rs.next());
            DBUtils.closeSQLStuff(rs, stmt);
            rs = null;
            stmt = null;
            for (int childId : children.toArray()) {
                this.collectTrashFolders(childId, folderId2Owner, userId, contextId, con);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustTrashOwnershipFor(int folderId, int oldOwner, Map<Integer, List<Map<Integer, List<VersionControlResult>>>> resultMaps, int userId, int contextId, Connection con) throws SQLException, OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE oxfolder_tree SET created_from=? WHERE cid=? AND fuid=?");
            stmt.setInt(1, userId);
            stmt.setInt(2, contextId);
            stmt.setInt(3, folderId);
            stmt.executeUpdate();
            Map<Integer, List<VersionControlResult>> resultMap = VersionControlUtil.changeFileStoreLocationsIfNecessary(oldOwner, userId, folderId, new ContextImpl(contextId), con);
            if (null != resultMap && !resultMap.isEmpty()) {
                Integer key = contextId;
                List<Map<Integer, List<VersionControlResult>>> list = resultMaps.get(key);
                if (null == list) {
                    list = new LinkedList<Map<Integer, List<VersionControlResult>>>();
                    resultMaps.put(key, list);
                }
                list.add(resultMap);
            }
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }
}

