/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.PrgDatesPrimaryKeyUpdateTask;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CalendarAddChangingDateIndexTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[]{PrgDatesPrimaryKeyUpdateTask.class.getName()};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = dbService.getForUpdateTask(cid);
        boolean rollback = false;
        try {
            con.setAutoCommit(false);
            rollback = true;
            String[] tables = new String[]{"prg_dates", "del_dates"};
            this.createCalendarIndex(con, tables);
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    private void createCalendarIndex(Connection con, String[] tables) {
        Logger log = LoggerFactory.getLogger(CalendarAddChangingDateIndexTask.class);
        String name = "changingDateIndex";
        for (String table : tables) {
            try {
                String indexName = Tools.existsIndex(con, table, new String[]{"cid", "changing_date"});
                if (null == indexName) {
                    log.info("Creating new index named \"{}\" with columns (cid,changing_date) on table {}.", (Object)"changingDateIndex", (Object)table);
                    Tools.createIndex(con, table, "changingDateIndex", new String[]{"cid", "changing_date"}, false);
                    continue;
                }
                log.info("New index named \"{}\" with columns (cid,changing_date) already exists on table {}.", (Object)indexName, (Object)table);
            }
            catch (SQLException e) {
                log.error("Problem adding index \"{}\" on table {}.", new Object[]{"changingDateIndex", table, e});
            }
        }
    }
}

