/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.Release781UpdateTask;
import com.openexchange.java.Strings;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class AddStartTLSColumnForMailAccountTablesTask
extends UpdateTaskAdapter {
    private final String[] TABLES = new String[]{"user_mail_account", "user_transport_account"};
    private final String[] SECURE_PROTOCOLS = new String[]{"imaps", "pop3s", "pops", "smtps"};

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        ConfigurationService configService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        boolean force = configService.getBoolProperty("com.openexchange.mail.enforceSecureConnection", false);
        Connection con = null;
        try {
            con = dbService.getForUpdateTask(contextId);
            con.setAutoCommit(false);
            Column column = new Column("starttls", "TINYINT UNSIGNED NOT NULL DEFAULT 0");
            for (String table : this.TABLES) {
                Tools.addColumns(con, table, column);
            }
            if (force) {
                this.activateStartTLS(con, force);
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            dbService.backForUpdateTask(contextId, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{Release781UpdateTask.class.getName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateStartTLS(Connection con, boolean forceSecure) throws SQLException {
        for (String table : this.TABLES) {
            PreparedStatement stmt = null;
            PreparedStatement stmt2 = null;
            ResultSet rs = null;
            try {
                stmt = con.prepareStatement("SELECT id, cid, user, url FROM " + table + " WHERE id <> 0 FOR UPDATE");
                rs = stmt.executeQuery();
                stmt2 = con.prepareStatement("UPDATE " + table + " SET starttls = ? WHERE id = ? AND cid = ? AND user = ?");
                while (rs.next()) {
                    int id = rs.getInt(1);
                    int cid = rs.getInt(2);
                    int user = rs.getInt(3);
                    String url = rs.getString(4);
                    boolean secure = this.checkSecureUrl(url) || forceSecure;
                    stmt2 = con.prepareStatement("UPDATE " + table + " SET starttls = ? WHERE id = ? AND cid = ? AND user = ?");
                    stmt2.setBoolean(1, secure);
                    stmt2.setInt(2, id);
                    stmt2.setInt(3, cid);
                    stmt2.setInt(4, user);
                    stmt2.addBatch();
                }
                stmt2.executeBatch();
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt2);
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
            DBUtils.closeSQLStuff(stmt2);
            DBUtils.closeSQLStuff(rs, stmt);
        }
    }

    private boolean checkSecureUrl(String url) {
        if (Strings.isEmpty((String)url)) {
            return false;
        }
        for (String protocol : this.SECURE_PROTOCOLS) {
            if (!url.toLowerCase().startsWith(protocol)) continue;
            return true;
        }
        return false;
    }
}

