/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;

abstract class AbstractUserAliasTableUpdateTask
extends UpdateTaskAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Alias> getAllAliasesInUserAttributes(Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        LinkedHashSet<Alias> aliases = new LinkedHashSet<Alias>();
        try {
            stmt = conn.prepareStatement("SELECT cid, id, value, uuid FROM user_attribute WHERE name='alias'");
            rs = stmt.executeQuery();
            if (!rs.next()) {
                Set<Alias> set = Collections.emptySet();
                return set;
            }
            do {
                int index = 0;
                int cid = rs.getInt(++index);
                int uid = rs.getInt(++index);
                String alias = rs.getString(++index);
                byte[] bytes = rs.getBytes(++index);
                UUID uuid = UUIDs.toUUID((byte[])bytes);
                aliases.add(new Alias(cid, uid, alias, uuid));
            } while (rs.next());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        return aliases;
    }

    class Alias {
        private final int cid;
        private final int userId;
        private final String alias;
        private final int hash;
        private final UUID uuid;

        Alias(int cid, int userId, String alias, UUID uuid) {
            this.cid = cid;
            this.userId = userId;
            this.alias = alias;
            this.uuid = uuid;
            int prime = 31;
            int result = 1;
            result = 31 * result + (alias == null ? 0 : alias.hashCode());
            result = 31 * result + cid;
            result = 31 * result + userId;
            this.hash = result = 31 * result + (uuid == null ? 0 : uuid.hashCode());
        }

        public int getCid() {
            return this.cid;
        }

        public int getUserId() {
            return this.userId;
        }

        public String getAlias() {
            return this.alias;
        }

        public int getHash() {
            return this.hash;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Alias other = (Alias)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
                return false;
            }
            if (this.cid != other.cid) {
                return false;
            }
            if (this.userId != other.userId) {
                return false;
            }
            return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
        }

        private AbstractUserAliasTableUpdateTask getOuterType() {
            return AbstractUserAliasTableUpdateTask.this;
        }
    }
}

