/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum SchemaExceptionCodes implements DisplayableOXExceptionCode
{
    ALREADY_LOCKED("Update conflict detected. Another process is currently updating schema %1$s.", "Error while updating database.", Category.CATEGORY_PERMISSION_DENIED, 3),
    LOCK_FAILED("Table update failed. Schema %1$s could not be locked.", "Error while updating database.", Category.CATEGORY_ERROR, 4),
    UPDATE_CONFLICT("Update conflict detected. Schema %1$s is not marked as locked.", "Error while updating database.", Category.CATEGORY_ERROR, 5),
    UNLOCK_FAILED("Schema %1$s could not be unlocked. Lock information could no be removed from database.", "Error while updating database.", Category.CATEGORY_ERROR, 6),
    SQL_PROBLEM("A SQL problem occurred: %1$s.", "Error while updating database.", Category.CATEGORY_ERROR, 7),
    DATABASE_DOWN("Cannot get database connection.", "Cannot get database connection.", Category.CATEGORY_SERVICE_DOWN, 8),
    WRONG_ROW_COUNT("Processed a wrong number of rows in database. Expected %1$d rows but worked on %2$d rows.", "Error while updating database.", Category.CATEGORY_ERROR, 9);

    final String message;
    final String displayMessage;
    final Category category;
    final int number;

    private SchemaExceptionCodes(String message, String displayMessage, Category category, int number) {
        this.message = message;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
        this.category = category;
        this.number = number;
    }

    public String getPrefix() {
        return "UPD";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.number;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

