/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.SQL;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskIterator2;
import com.openexchange.groupware.tasks.TaskSearch;
import com.openexchange.tools.Collections;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.iterator.CombinedSearchIterator;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class RdbTaskSearch
extends TaskSearch {
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("((^|[^\\\\])%)|((^|[^\\\\])_)");

    RdbTaskSearch() {
    }

    @Override
    int[] findUserTasks(Context ctx, Connection con, int userId, StorageType type) throws OXException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        ArrayList<Integer> tasks2 = new ArrayList<Integer>();
        try {
            stmt = con.prepareStatement(SQL.SEARCH_USER_TASKS.get((Object)type));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, userId);
            result = stmt.executeQuery();
            while (result.next()) {
                tasks2.add(result.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return Collections.toArray(tasks2);
    }

    @Override
    SearchIterator<Task> listModifiedTasks(final Context ctx, final int folderId, StorageType type, int[] columns, final Date since, final boolean onlyOwn, final int userId, boolean noPrivate) throws OXException {
        StringBuilder sql1 = new StringBuilder();
        sql1.append("SELECT ");
        sql1.append(SQL.getFields(columns, false));
        sql1.append(" FROM ");
        String taskTable = SQL.TASK_TABLES.get((Object)type);
        sql1.append(taskTable);
        sql1.append(" JOIN ");
        String folderTable = SQL.FOLDER_TABLES.get((Object)type);
        sql1.append(folderTable);
        sql1.append(" USING (cid,id) WHERE ");
        sql1.append(taskTable);
        sql1.append(".cid=? AND ");
        sql1.append(folderTable);
        sql1.append(".folder=? AND ");
        sql1.append(taskTable);
        sql1.append(".last_modified>?");
        if (onlyOwn) {
            sql1.append(" AND ");
            sql1.append(SQL.getOnlyOwn(taskTable));
        }
        if (noPrivate) {
            sql1.append(" AND ");
            sql1.append(SQL.getNoPrivate(taskTable));
        }
        TaskIterator2 iter1 = new TaskIterator2(ctx, userId, sql1.toString(), new TaskIterator2.StatementSetter(){

            @Override
            public void perform(PreparedStatement stmt) throws SQLException {
                int pos = 1;
                stmt.setInt(pos++, ctx.getContextId());
                stmt.setInt(pos++, folderId);
                stmt.setLong(pos++, since.getTime());
                if (onlyOwn) {
                    stmt.setInt(pos++, userId);
                }
            }
        }, folderId, columns, type);
        if (StorageType.DELETED == type) {
            StringBuilder sql2 = new StringBuilder();
            sql2.append("SELECT ");
            String activeTaskTable = SQL.TASK_TABLES.get((Object)StorageType.ACTIVE);
            sql2.append(SQL.getFields(columns, false, activeTaskTable));
            sql2.append(" FROM ");
            sql2.append(activeTaskTable);
            sql2.append(" JOIN ");
            String removedPartsTable = SQL.PARTS_TABLES.get((Object)StorageType.REMOVED);
            sql2.append(removedPartsTable);
            sql2.append(" ON ");
            sql2.append(activeTaskTable);
            sql2.append(".cid=");
            sql2.append(removedPartsTable);
            sql2.append(".cid AND ");
            sql2.append(activeTaskTable);
            sql2.append(".id=");
            sql2.append(removedPartsTable);
            sql2.append(".task ");
            sql2.append("WHERE ");
            sql2.append(activeTaskTable);
            sql2.append(".cid=? AND ");
            sql2.append(removedPartsTable);
            sql2.append(".folder=? AND ");
            sql2.append(activeTaskTable);
            sql2.append(".last_modified>?");
            if (onlyOwn) {
                sql2.append(" AND ");
                sql2.append(SQL.getOnlyOwn(activeTaskTable));
            }
            if (noPrivate) {
                sql2.append(" AND ");
                sql2.append(SQL.getNoPrivate(activeTaskTable));
            }
            TaskIterator2 iter2 = new TaskIterator2(ctx, userId, sql2.toString(), new TaskIterator2.StatementSetter(){

                @Override
                public void perform(PreparedStatement stmt) throws SQLException {
                    int pos = 1;
                    stmt.setInt(pos++, ctx.getContextId());
                    stmt.setInt(pos++, folderId);
                    stmt.setLong(pos++, since.getTime());
                    if (onlyOwn) {
                        stmt.setInt(pos++, userId);
                    }
                }
            }, folderId, columns, StorageType.REMOVED);
            return new CombinedSearchIterator(new SearchIterator[]{iter1, iter2});
        }
        return iter1;
    }

    @Override
    public SearchIterator<Task> find(final Context context, final int userID, TaskSearchObject searchObject, int[] columns, int orderBy, Order order, final List<Integer> all, final List<Integer> own, final List<Integer> shared) throws OXException {
        Set<String> queries;
        Set<String> attachmentFilters;
        Set<Integer> statusFilters;
        Set<String> descriptionFilters;
        final ArrayList<Object> searchParameters = new ArrayList<Object>();
        StringBuilder builder = new StringBuilder();
        String fields = SQL.getFields(columns, true, "t");
        builder.append("SELECT DISTINCT ").append(fields);
        builder.append(" FROM task AS t ");
        builder.append(" LEFT JOIN task_folder AS tf ON (tf.id = t.id AND tf.cid = t.cid)");
        builder.append(" LEFT JOIN prg_attachment AS a ON (t.cid = a.cid AND t.id = a.attached)");
        if (searchObject.hasInternalParticipants()) {
            builder.append(" LEFT JOIN task_participant AS tp ON (t.cid = tp.cid AND t.id = tp.task)");
        }
        if (searchObject.hasExternalParticipants()) {
            builder.append(" LEFT JOIN task_eparticipant AS etp ON (t.cid = etp.cid AND t.id = etp.task)");
        }
        builder.append(" WHERE ");
        builder.append(" t.cid = ? AND ");
        builder.append(SQL.allFoldersWhere(all, own, shared));
        Set<String> titleFilters = searchObject.getTitles();
        if (titleFilters != null && titleFilters.size() > 0) {
            for (String t : titleFilters) {
                builder.append(" AND ");
                String preparedPattern = StringCollection.prepareForSearch(t, true, true);
                builder.append(RdbTaskSearch.containsWildcards(preparedPattern) ? " t.title LIKE ? " : " t.title = ? ");
                searchParameters.add(preparedPattern);
            }
        }
        if ((descriptionFilters = searchObject.getNotes()) != null && descriptionFilters.size() > 0) {
            for (String t : descriptionFilters) {
                builder.append(" AND ");
                String preparedPattern = StringCollection.prepareForSearch(t, true, true);
                builder.append(RdbTaskSearch.containsWildcards(preparedPattern) ? " t.description LIKE ? " : " t.description = ? ");
                searchParameters.add(preparedPattern);
            }
        }
        if ((statusFilters = searchObject.getStateFilters()) != null && statusFilters.size() > 0) {
            builder.append(" AND (");
            int i = 0;
            for (Integer s : statusFilters) {
                if (i++ > 0) {
                    builder.append(" OR ");
                }
                builder.append(" t.state = ? ");
                searchParameters.add(s);
            }
            builder.append(" ) ");
        }
        if ((attachmentFilters = searchObject.getAttachmentNames()) != null && attachmentFilters.size() > 0) {
            for (String t : attachmentFilters) {
                builder.append(" AND ");
                String preparedPattern = StringCollection.prepareForSearch(t, true, true);
                builder.append(RdbTaskSearch.containsWildcards(preparedPattern) ? " a.filename LIKE ? " : " a.filename = ? ");
                searchParameters.add(preparedPattern);
            }
        }
        if ((queries = searchObject.getQueries()) != null && queries.size() > 0) {
            for (String q : queries) {
                String preparedPattern = StringCollection.prepareForSearch(q, true, true);
                builder.append(RdbTaskSearch.containsWildcards(preparedPattern) ? " AND (t.description LIKE ? OR t.title LIKE ? OR a.filename LIKE ? ) " : " AND (t.description = ? OR t.title = ? OR a.filename = ?) ");
                searchParameters.add(preparedPattern);
                searchParameters.add(preparedPattern);
                searchParameters.add(preparedPattern);
            }
        }
        if (searchObject.hasParticipants()) {
            builder.append(" AND ( ");
            int i = 0;
            for (Integer id : searchObject.getUserIDs()) {
                if (i++ > 0) {
                    builder.append(" AND ");
                }
                builder.append(" t.id IN ( SELECT tp.task FROM task_participant AS tp WHERE t.id = tp.task AND t.cid = tp.cid AND tp.user = ? )");
                searchParameters.add(id);
            }
            i = 0;
            for (String mail : searchObject.getExternalParticipants()) {
                if (searchObject.hasInternalParticipants() || i++ >= 1) {
                    builder.append(" AND ");
                }
                String preparedPattern = StringCollection.prepareForSearch(mail, false, false);
                builder.append(" etp.mail = ? ");
                searchParameters.add(preparedPattern);
            }
            builder.append(" ) ");
        }
        if (searchObject.isSingleOccurenceFilter()) {
            builder.append(" AND t.recurrence_type = 0 ");
        } else if (searchObject.isSeriesFilter()) {
            builder.append(" AND t.recurrence_type > 0 ");
        }
        builder.append(SQL.getOrder(orderBy, order)).append(SQL.getLimit(searchObject.getStart(), searchObject.getSize()));
        TaskIterator2.StatementSetter ss = new TaskIterator2.StatementSetter(){

            @Override
            public void perform(PreparedStatement stmt) throws SQLException {
                int i;
                int pos = 1;
                stmt.setInt(pos++, context.getContextId());
                Iterator i$ = all.iterator();
                while (i$.hasNext()) {
                    i = (Integer)i$.next();
                    stmt.setInt(pos++, i);
                }
                i$ = own.iterator();
                while (i$.hasNext()) {
                    i = (Integer)i$.next();
                    stmt.setInt(pos++, i);
                }
                if (own.size() > 0) {
                    stmt.setInt(pos++, userID);
                }
                i$ = shared.iterator();
                while (i$.hasNext()) {
                    i = (Integer)i$.next();
                    stmt.setInt(pos++, i);
                }
                for (Object o : searchParameters) {
                    stmt.setObject(pos++, o);
                }
            }
        };
        TaskIterator2 it = new TaskIterator2(context, userID, builder.toString(), ss, -1, columns, StorageType.ACTIVE);
        return it;
    }

    private static boolean containsWildcards(String pattern) {
        return null != pattern && WILDCARD_PATTERN.matcher(pattern).find();
    }
}

