/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import java.sql.Connection;

public final class Permission {
    private Permission() {
    }

    public static void checkDelete(Context ctx, User user, UserPermissionBits userPerms, FolderObject folder, Task task) throws OXException {
        boolean onlyOwn;
        Permission.checkForTaskFolder(folder);
        OCLPermission permission = Permission.getPermission(ctx, user, userPerms, folder);
        if (!permission.canDeleteAllObjects() && !permission.canDeleteOwnObjects()) {
            throw TaskExceptionCode.NO_DELETE_PERMISSION.create();
        }
        boolean bl = onlyOwn = !permission.canDeleteAllObjects() && permission.canDeleteOwnObjects();
        if (onlyOwn && task.getCreatedBy() != user.getId()) {
            throw TaskExceptionCode.NO_DELETE_PERMISSION.create();
        }
        boolean noPrivate = Tools.isFolderShared(folder, user);
        if (noPrivate && task.getPrivateFlag()) {
            throw TaskExceptionCode.NO_DELETE_PERMISSION.create();
        }
    }

    static void checkDelegation(UserPermissionBits userPerms, Participant[] participants) throws OXException {
        if (!userPerms.canDelegateTasks() && null != participants && participants.length > 0) {
            throw TaskExceptionCode.NO_DELEGATE_PERMISSION.create();
        }
    }

    static void checkCreate(Context ctx, User user, UserPermissionBits userPerms, FolderObject folder) throws OXException {
        if (!userPerms.hasTask()) {
            throw TaskExceptionCode.NO_TASKS.create(user.getId());
        }
        Permission.checkForTaskFolder(folder);
        OCLPermission permission = Permission.getPermission(ctx, user, userPerms, folder);
        if (!permission.canCreateObjects()) {
            throw TaskExceptionCode.NO_CREATE_PERMISSION.create(folder.getFolderName(), Autoboxing.I((int)folder.getObjectID()));
        }
    }

    static boolean canOnlySeeFolder(Context ctx, User user, UserPermissionBits userPerms, FolderObject folder) throws OXException {
        Permission.checkForTaskFolder(folder);
        OCLPermission permission = Permission.getPermission(ctx, user, userPerms, folder);
        return permission.isFolderVisible() && !permission.canReadAllObjects() && !permission.canReadOwnObjects();
    }

    static boolean isFolderVisible(Context ctx, User user, UserPermissionBits userPerms, FolderObject folder) throws OXException {
        Permission.checkForTaskFolder(folder);
        OCLPermission permission = Permission.getPermission(ctx, user, userPerms, folder);
        return permission.isFolderVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean canReadInFolder(Context ctx, User user, UserPermissionBits userPerms, FolderObject folder) throws OXException {
        Connection con = DBPool.pickup(ctx);
        try {
            boolean bl = Permission.canReadInFolder(ctx, con, user, userPerms, folder);
            return bl;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    static boolean canReadInFolder(Context ctx, Connection con, User user, UserPermissionBits userPerms, FolderObject folder) throws OXException {
        Permission.checkForTaskFolder(folder);
        OCLPermission permission = Permission.getPermission(ctx, con, user, userPerms, folder);
        if (!permission.canReadAllObjects() && !permission.canReadOwnObjects()) {
            throw TaskExceptionCode.NO_READ_PERMISSION.create(folder.getFolderName(), Autoboxing.I((int)folder.getObjectID()));
        }
        return !permission.canReadAllObjects() && permission.canReadOwnObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void canReadInFolder(Context ctx, User user, UserPermissionBits userPerms, FolderObject folder, Task task) throws OXException {
        Connection con = DBPool.pickup(ctx);
        try {
            Permission.canReadInFolder(ctx, con, user, userPerms, folder, task);
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    static void canReadInFolder(Context ctx, Connection con, User user, UserPermissionBits userPerms, FolderObject folder, Task task) throws OXException {
        boolean onlyOwn = Permission.canReadInFolder(ctx, con, user, userPerms, folder);
        if (onlyOwn && user.getId() != task.getCreatedBy()) {
            throw TaskExceptionCode.NO_READ_PERMISSION.create(folder.getFolderName(), Autoboxing.I((int)folder.getObjectID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkReadInFolder(Context ctx, User user, UserPermissionBits userPerms, FolderObject folder) throws OXException {
        Connection con = DBPool.pickup(ctx);
        try {
            Permission.checkReadInFolder(ctx, con, user, userPerms, folder);
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    static void checkReadInFolder(Context ctx, Connection con, User user, UserPermissionBits userPerms, FolderObject folder) throws OXException {
        Permission.checkForTaskFolder(folder);
        OCLPermission permission = Permission.getPermission(ctx, con, user, userPerms, folder);
        if (!permission.canReadAllObjects() && !permission.canReadOwnObjects()) {
            throw TaskExceptionCode.NO_READ_PERMISSION.create(folder.getFolderName(), Autoboxing.I((int)folder.getObjectID()));
        }
    }

    static void checkWriteInFolder(Context ctx, User user, UserPermissionBits userPermissionBits, FolderObject folder, Task task) throws OXException {
        Permission.checkForTaskFolder(folder);
        OCLPermission permission = Permission.getPermission(ctx, user, userPermissionBits, folder);
        if (!(permission.canWriteAllObjects() || permission.canWriteOwnObjects() && user.getId() == task.getCreatedBy())) {
            throw TaskExceptionCode.NO_WRITE_PERMISSION.create(folder.getFolderName(), Autoboxing.I((int)folder.getObjectID()));
        }
    }

    static OCLPermission getPermission(Context ctx, User user, UserPermissionBits userPermissionBits, FolderObject folder) throws OXException {
        return new OXFolderAccess(ctx).getFolderPermission(folder.getObjectID(), user.getId(), userPermissionBits);
    }

    static OCLPermission getPermission(Context ctx, Connection con, User user, UserPermissionBits userPerms, FolderObject folder) throws OXException {
        return new OXFolderAccess(con, ctx).getFolderPermission(folder.getObjectID(), user.getId(), userPerms);
    }

    static void checkForTaskFolder(FolderObject folder) throws OXException {
        if (!Tools.isFolderTask(folder)) {
            throw TaskExceptionCode.NOT_TASK_FOLDER.create(folder.getFolderName(), Autoboxing.I((int)folder.getObjectID()));
        }
    }
}

