/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.InternalParticipant;
import com.openexchange.groupware.tasks.RdbFolderStorage;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.server.impl.DBPool;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class FolderStorage {
    private static final FolderStorage SINGLETON = new RdbFolderStorage();

    protected FolderStorage() {
    }

    public static FolderStorage getInstance() {
        return SINGLETON;
    }

    public abstract void insertFolder(Context var1, Connection var2, int var3, Set<Folder> var4, StorageType var5) throws OXException;

    void insertFolder(Context ctx, Connection con, int taskId, Folder folder, StorageType type) throws OXException {
        HashSet<Folder> folders2 = new HashSet<Folder>();
        folders2.add(folder);
        this.insertFolder(ctx, con, taskId, folders2, type);
    }

    public abstract Set<Folder> selectFolder(Context var1, Connection var2, int var3, StorageType var4) throws OXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Folder> selectFolder(Context ctx, int taskId, StorageType type) throws OXException {
        Connection con = DBPool.pickup(ctx);
        try {
            Set<Folder> set = this.selectFolder(ctx, con, taskId, type);
            return set;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    public abstract Folder selectFolderByUser(Context var1, Connection var2, int var3, int var4, StorageType var5) throws OXException;

    abstract Folder selectFolderById(Context var1, Connection var2, int var3, int var4, StorageType var5) throws OXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Folder selectFolderById(Context ctx, int taskId, int folderId, StorageType type) throws OXException {
        Connection con = DBPool.pickup(ctx);
        try {
            Folder folder = this.selectFolderById(ctx, con, taskId, folderId, type);
            return folder;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    abstract void deleteFolder(Context var1, Connection var2, int var3, int[] var4, StorageType var5, boolean var6) throws OXException;

    void deleteFolder(Context ctx, Connection con, int taskId, int folderId, StorageType type) throws OXException {
        this.deleteFolder(ctx, con, taskId, new int[]{folderId}, type, true);
    }

    void deleteFolder(Context ctx, Connection con, int taskId, int folderId, StorageType type, boolean sanityCheck) throws OXException {
        this.deleteFolder(ctx, con, taskId, new int[]{folderId}, type, sanityCheck);
    }

    void deleteFolder(Context ctx, Connection con, int taskId, Set<Folder> folders2, StorageType type) throws OXException {
        this.deleteFolder(ctx, con, taskId, folders2, type, true);
    }

    void deleteFolder(Context ctx, Connection con, int taskId, Set<Folder> folders2, StorageType type, boolean sanityCheck) throws OXException {
        if (0 == folders2.size()) {
            return;
        }
        int[] folderIds = new int[folders2.size()];
        Iterator<Folder> iter = folders2.iterator();
        for (int i = 0; i < folderIds.length; ++i) {
            folderIds[i] = iter.next().getIdentifier();
        }
        this.deleteFolder(ctx, con, taskId, folderIds, type, sanityCheck);
    }

    abstract int[] getTasksInFolder(Context var1, Connection var2, int var3, StorageType var4) throws OXException;

    abstract int[][] searchFolderByUser(Context var1, Connection var2, int var3, StorageType var4) throws OXException;

    public static Folder extractFolderOfUser(Set<Folder> folders2, int userId) {
        Folder retval = null;
        for (Folder folder : folders2) {
            if (folder.getUser() != userId) continue;
            retval = folder;
            break;
        }
        return retval;
    }

    public static Set<Folder> extractNonParticipantFolder(Set<Folder> folders2, Set<InternalParticipant> participants) {
        HashSet<Folder> retval = new HashSet<Folder>();
        retval.addAll(folders2);
        for (InternalParticipant participant : participants) {
            Folder remove = FolderStorage.extractFolderOfUser(retval, participant.getIdentifier());
            if (null == remove) continue;
            retval.remove(remove);
        }
        return retval;
    }

    static Folder getFolder(Set<Folder> folders2, int folderId) {
        Folder retval = null;
        for (Folder folder : folders2) {
            if (folder.getIdentifier() != folderId) continue;
            retval = folder;
            break;
        }
        return retval;
    }
}

