/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.mail;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.ReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Module
implements PreferencesItemService {
    private static final Logger LOG = LoggerFactory.getLogger(Module.class);

    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "module"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new ReadOnlyValue(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                if (userConfig.isMultipleMailAccounts() && ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class) != null) {
                    setting.setSingleValue(Boolean.TRUE);
                    return;
                }
                MailAccess<IMailFolderStorage, IMailMessageStorage> mail = null;
                try {
                    mail = MailAccess.getInstance(session);
                    mail.connect();
                    setting.setSingleValue(Boolean.TRUE);
                }
                catch (OXException e) {
                    setting.setSingleValue(Boolean.FALSE);
                    LOG.error("", (Throwable)e);
                }
                finally {
                    if (null != mail) {
                        mail.close(true);
                    }
                }
            }

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasWebMail();
            }
        };
    }
}

