/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.mail;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.ReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.Protocol;
import com.openexchange.session.Session;
import java.util.List;
import org.json.JSONArray;

public class MailProtocols
implements PreferencesItemService {
    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "protocols"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new ReadOnlyValue(){

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasWebMail();
            }

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                List<Protocol> protocols = MailProviderRegistry.getProtocols();
                if (null == protocols || protocols.isEmpty()) {
                    setting.setSingleValue(null);
                } else {
                    JSONArray jArray = new JSONArray();
                    for (Protocol protocol : protocols) {
                        jArray.put((Object)protocol.getName());
                    }
                    setting.setSingleValue(jArray);
                }
            }
        };
    }
}

