/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.json.actions;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.api2.ReminderService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.reminder.json.ReminderAJAXRequest;
import com.openexchange.groupware.tasks.TasksSQLImpl;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReminderAction
implements AJAXActionService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReminderAction.class);
    private static final AJAXRequestResult RESULT_JSON_NULL = new AJAXRequestResult(JSONObject.NULL, "json");
    private final ServiceLookup services;

    protected AbstractReminderAction(ServiceLookup services) {
        this.services = services;
    }

    protected AppointmentSqlFactoryService getService() {
        return (AppointmentSqlFactoryService)this.services.getService(AppointmentSqlFactoryService.class);
    }

    protected <S> S getService(Class<? extends S> clazz) {
        return (S)this.services.getService(clazz);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        try {
            ReminderAJAXRequest reminderRequest = new ReminderAJAXRequest(requestData, session);
            String sTimeZone = requestData.getParameter("timezone");
            if (null != sTimeZone) {
                reminderRequest.setTimeZone(TimeZoneUtils.getTimeZone(sTimeZone));
            }
            return this.perform(reminderRequest);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }

    protected abstract AJAXRequestResult perform(ReminderAJAXRequest var1) throws OXException, JSONException;

    protected static AJAXRequestResult getJSONNullResult() {
        return RESULT_JSON_NULL;
    }

    protected boolean getLatestRecurringReminder(Session session, TimeZone tz, Date endRange, ReminderObject reminder) throws OXException {
        CalendarDataObject calendarDataObject;
        AppointmentSQLInterface calendarSql = this.getService().createAppointmentSql(session);
        CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        try {
            calendarDataObject = calendarSql.getObjectById(reminder.getTargetId(), reminder.getFolder());
        }
        catch (SQLException e) {
            throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
        }
        Calendar calendar2 = Calendar.getInstance(tz);
        calendar2.add(2, -3);
        RecurringResultsInterface recurringResults = recColl.calculateRecurring(calendarDataObject, calendar2.getTimeInMillis(), endRange.getTime() + (long)(calendarDataObject.getAlarm() * 60 * 1000), 0);
        boolean retval = false;
        if (recurringResults != null && recurringResults.size() > 0) {
            RecurringResultInterface recurringResult = recurringResults.getRecurringResult(recurringResults.size() - 1);
            calendar2.setTimeInMillis(recurringResult.getStart());
            calendar2.add(12, -calendarDataObject.getAlarm());
            if (calendar2.getTimeInMillis() >= reminder.getDate().getTime()) {
                reminder.setDate(calendar2.getTime());
                reminder.setRecurrencePosition(recurringResult.getPosition());
                retval = true;
            }
        } else if (calendarDataObject.getRecurrenceID() != calendarDataObject.getObjectID()) {
            retval = true;
        }
        return retval;
    }

    protected static boolean hasModulePermission(ReminderObject reminder, ServerSession session) {
        switch (reminder.getModule()) {
            case 1: {
                return session.getUserPermissionBits().hasCalendar();
            }
            case 4: {
                return session.getUserPermissionBits().hasTask();
            }
        }
        return true;
    }

    protected static boolean stillAccepted(ReminderObject reminder, ServerSession session) throws OXException {
        switch (reminder.getModule()) {
            case 1: {
                try {
                    UserParticipant[] userParticipants;
                    AppointmentSqlFactoryService factoryService = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class);
                    if (null == factoryService || null == (userParticipants = factoryService.createAppointmentSql(session).getObjectById(reminder.getTargetId(), reminder.getFolder()).getUsers())) break;
                    int userId = session.getUserId();
                    for (UserParticipant userParticipant : userParticipants) {
                        if (userParticipant.getIdentifier() != userId) continue;
                        return userParticipant.getConfirm() != 2;
                    }
                    break;
                }
                catch (SQLException e) {
                    throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
                }
            }
            case 4: {
                UserParticipant[] userParticipants = new TasksSQLImpl(session).getTaskById(reminder.getTargetId(), reminder.getFolder()).getUsers();
                if (null == userParticipants) break;
                int userId = session.getUserId();
                for (UserParticipant userParticipant : userParticipants) {
                    if (userParticipant.getIdentifier() != userId) continue;
                    return userParticipant.getConfirm() != 2;
                }
                break;
            }
            default: {
                return true;
            }
        }
        return true;
    }

    protected static final ReminderObject getNextRecurringReminder(Session session, TimeZone tz, ReminderObject reminder) throws OXException {
        RecurringResultsInterface recurringResults;
        CalendarDataObject calendarDataObject;
        AppointmentSQLInterface calendarSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(session);
        CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        try {
            calendarDataObject = calendarSql.getObjectById(reminder.getTargetId(), reminder.getFolder());
        }
        catch (SQLException e) {
            throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
        }
        try {
            long end_mod = calendarDataObject.getEndDate().getTime() % 86400000L;
            Date until = null;
            until = new Date(((CalendarObject)calendarDataObject).getUntil().getTime() + end_mod + (long)tz.getOffset(((CalendarObject)calendarDataObject).getUntil().getTime()));
            recurringResults = recColl.calculateRecurring(calendarDataObject, reminder.getDate().getTime(), until.getTime(), 0);
        }
        catch (OXException e) {
            LOG.error("Can't calculate next recurrence for appointment {} in context {}", new Object[]{reminder.getTargetId(), session.getContextId(), e});
            return null;
        }
        if (null == recurringResults || recurringResults.size() == 0) {
            return null;
        }
        ReminderObject nextReminder = null;
        Date now = new Date();
        for (int i = 0; i < recurringResults.size(); ++i) {
            RecurringResultInterface recurringResult = recurringResults.getRecurringResult(i);
            Calendar calendar2 = Calendar.getInstance(tz);
            calendar2.setTimeInMillis(recurringResult.getStart());
            calendar2.add(12, -calendarDataObject.getAlarm());
            if (!calendar2.getTime().after(reminder.getDate()) || !calendar2.getTime().after(now)) continue;
            nextReminder = reminder.clone();
            nextReminder.setRecurrenceAppointment(true);
            nextReminder.setRecurrencePosition(recurringResult.getPosition());
            nextReminder.setDate(calendar2.getTime());
            break;
        }
        return nextReminder;
    }

    protected static void deleteReminderSafe(ReminderObject reminder, int userId, ReminderService reminderSql) {
        try {
            reminderSql.deleteReminder(reminder.getTargetId(), userId, reminder.getModule());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

