/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify;

import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.mail.MailObject;
import com.openexchange.groupware.notify.LinkableState;
import com.openexchange.groupware.notify.State;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.i18n.tools.StringTemplate;
import com.openexchange.i18n.tools.Template;
import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.tools.session.ServerSession;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class TaskState
extends LinkableState {
    private final TemplateReplacement actionRepl;
    private final TemplateReplacement confirmationActionRepl;
    private final String messageTemplate;
    private final State.Type type;
    private static final Set<Integer> FIELDS_TO_IGNORE = new HashSet<Integer>(Arrays.asList(204, 5));

    public TaskState(TemplateReplacement actionRepl, String messageTemplate, State.Type type) {
        this(actionRepl, null, messageTemplate, type);
    }

    public TaskState(TemplateReplacement actionRepl, TemplateReplacement confirmationActionRepl, String messageTemplate, State.Type type) {
        this.actionRepl = actionRepl;
        this.confirmationActionRepl = confirmationActionRepl;
        this.messageTemplate = messageTemplate;
        this.type = type;
    }

    @Override
    public boolean sendMail(UserSettingMail userSettingMail, int owner, int participant, int modificationUser) {
        if (participant == modificationUser) {
            return false;
        }
        switch (this.type) {
            case ACCEPTED: 
            case DECLINED: 
            case TENTATIVELY_ACCEPTED: {
                return participant == owner ? userSettingMail.isNotifyTasksConfirmOwner() : userSettingMail.isNotifyTasksConfirmParticipant();
            }
            case REMINDER: {
                return false;
            }
        }
        return userSettingMail.isNotifyTasks();
    }

    @Override
    public int getModule() {
        return 4;
    }

    @Override
    public void modifyInternal(MailObject mail, CalendarObject obj, ServerSession sessObj) {
    }

    @Override
    public void modifyExternal(MailObject mail, CalendarObject obj, ServerSession sessObj) {
    }

    @Override
    public DateFormat getDateFormat(Locale locale) {
        return DateFormat.getDateInstance(2, locale);
    }

    @Override
    public Template getTemplate() {
        return new StringTemplate(this.messageTemplate);
    }

    @Override
    public TemplateReplacement getAction() {
        return this.actionRepl;
    }

    @Override
    public TemplateReplacement getConfirmationAction() {
        return this.confirmationActionRepl;
    }

    @Override
    public State.Type getType() {
        return this.type;
    }

    @Override
    public boolean onlyIrrelevantFieldsChanged(CalendarObject oldObj, CalendarObject newObj) {
        if (Task.class.isInstance(oldObj) && Task.class.isInstance(newObj)) {
            Set<Integer> differingFields = ((Task)oldObj).findDifferingFields((Task)newObj);
            differingFields.removeAll(FIELDS_TO_IGNORE);
            return differingFields.isEmpty();
        }
        return false;
    }
}

