/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.utils;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorExceptionCodes;
import com.openexchange.tools.iterator.SearchIterators;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;

public class CombinedFilteringFileSearchIterator
implements SearchIterator<DocumentMetadata> {
    private final SearchIterator<DocumentMetadata>[] iterators;
    private final TIntSet ids;
    private DocumentMetadata next = null;
    private int i = 0;
    private OXException[] warnings;
    private Boolean hasWarnings;

    public CombinedFilteringFileSearchIterator(SearchIterator<DocumentMetadata> first, SearchIterator<DocumentMetadata> second) throws OXException {
        this.iterators = new SearchIterator[]{first, second};
        this.ids = new TIntHashSet(16);
        this.next = this.initNext();
    }

    public CombinedFilteringFileSearchIterator(SearchIterator<DocumentMetadata> ... iterators) throws OXException {
        this.iterators = iterators;
        this.ids = new TIntHashSet(16);
        this.next = this.initNext();
    }

    public boolean hasNext() throws OXException {
        return null != this.next;
    }

    public DocumentMetadata next() throws OXException {
        DocumentMetadata retval = this.next;
        if (null == retval) {
            throw SearchIteratorExceptionCodes.NO_SUCH_ELEMENT.create().setPrefix("NON");
        }
        this.next = this.initNext();
        return retval;
    }

    private DocumentMetadata initNext() throws OXException {
        if (this.iterators.length == 0) {
            return null;
        }
        DocumentMetadata next = null;
        while (this.i < this.iterators.length && null == next) {
            SearchIterator<DocumentMetadata> iter = this.iterators[this.i];
            if (iter.hasNext()) {
                DocumentMetadata metadata = (DocumentMetadata)iter.next();
                if (null == metadata || !this.ids.add(metadata.getId())) continue;
                next = metadata;
                continue;
            }
            ++this.i;
        }
        return next;
    }

    public void close() {
        for (SearchIterator<DocumentMetadata> iter : this.iterators) {
            SearchIterators.close(iter);
        }
    }

    public int size() {
        return -1;
    }

    public void addWarning(OXException warning) {
        throw new UnsupportedOperationException("Mehtod addWarning() not implemented");
    }

    public OXException[] getWarnings() {
        if (null == this.warnings) {
            if (this.iterators.length == 0) {
                this.warnings = new OXException[0];
            } else {
                ArrayList<OXException> list = new ArrayList<OXException>(this.iterators.length << 1);
                for (SearchIterator<DocumentMetadata> iter : this.iterators) {
                    if (!iter.hasWarnings()) continue;
                    list.addAll(Arrays.asList(this.iterators[this.i].getWarnings()));
                }
                this.warnings = list.toArray(new OXException[list.size()]);
            }
        }
        return this.warnings.length == 0 ? null : this.warnings;
    }

    public boolean hasWarnings() {
        if (null == this.hasWarnings) {
            if (this.iterators.length == 0) {
                this.hasWarnings = Boolean.FALSE;
            } else {
                this.hasWarnings = Boolean.FALSE;
                for (SearchIterator<DocumentMetadata> iter : this.iterators) {
                    if (!iter.hasWarnings()) continue;
                    this.hasWarnings = Boolean.TRUE;
                    break;
                }
            }
        }
        return this.hasWarnings;
    }
}

