/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.search;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.search.SearchTerm;
import com.openexchange.java.Strings;

public abstract class AbstractStringSearchTerm
implements SearchTerm<String> {
    protected final String pattern;
    protected final boolean ignoreCase;
    protected final boolean substringSearch;

    protected AbstractStringSearchTerm(String pattern, boolean ignoreCase, boolean substringSearch) {
        this.pattern = pattern;
        this.ignoreCase = ignoreCase;
        this.substringSearch = substringSearch;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public boolean isSubstringSearch() {
        return this.substringSearch;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public boolean matches(DocumentMetadata file) throws OXException {
        String str = this.getString(file);
        if (Strings.isEmpty((String)str)) {
            return false;
        }
        if (this.substringSearch) {
            return this.ignoreCase ? Strings.toLowerCase((CharSequence)str).indexOf(Strings.toLowerCase((CharSequence)this.pattern)) >= 0 : str.indexOf(this.pattern) >= 0;
        }
        return this.ignoreCase ? Strings.toLowerCase((CharSequence)str).equals(Strings.toLowerCase((CharSequence)this.pattern)) : str.equals(this.pattern);
    }

    protected abstract String getString(DocumentMetadata var1);
}

