/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.AbstractDocumentUpdateAction;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.java.Autoboxing;
import com.openexchange.session.Session;
import java.sql.DataTruncation;
import java.util.Collections;
import java.util.List;

public class UpdateVersionAction
extends AbstractDocumentUpdateAction {
    public UpdateVersionAction(Session session) {
        super(session);
    }

    public UpdateVersionAction(DBProvider provider, InfostoreQueryCatalog queryCatalog, Context context, DocumentMetadata version2, DocumentMetadata oldVersion, Metadata[] modifiedColums, long sequenceNumber, Session session) {
        this(provider, queryCatalog, context, Collections.singletonList(version2), Collections.singletonList(oldVersion), modifiedColums, sequenceNumber, session);
    }

    public UpdateVersionAction(DBProvider provider, InfostoreQueryCatalog queryCatalog, Context context, List<DocumentMetadata> versions, List<DocumentMetadata> oldVersions, Metadata[] modifiedColums, long sequenceNumber, Session session) {
        super(provider, queryCatalog, context, versions, oldVersions, modifiedColums, sequenceNumber, session);
    }

    protected void undoAction() throws OXException {
        int counter = this.doUpdates(this.getQueryCatalog().getVersionUpdate(this.getModified()), this.getQueryCatalog().filterForVersion(this.getModified()), this.getOldDocuments());
        if (counter < 0) {
            throw InfostoreExceptionCodes.UPDATED_BETWEEN_DO_AND_UNDO.create();
        }
    }

    public void perform() throws OXException {
        int counter = 0;
        Metadata[] fields = this.getQueryCatalog().filterForVersion(this.getModified());
        fields = this.getQueryCatalog().filterWritable(fields);
        try {
            counter = this.doUpdates(this.getQueryCatalog().getVersionUpdate(fields), fields, this.getDocuments());
        }
        catch (OXException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof DataTruncation)) {
                throw e;
            }
            DataTruncation dt = (DataTruncation)cause;
            throw OXCalendarExceptionCodes.TRUNCATED_SQL_ERROR.create(dt, new Object[0]);
        }
        this.setTimestamp(System.currentTimeMillis());
        if (counter <= 0) {
            throw InfostoreExceptionCodes.MODIFIED_CONCURRENTLY.create();
        }
    }

    @Override
    protected Object[] getAdditionals(DocumentMetadata doc) {
        return new Object[]{Autoboxing.I((int)this.getContext().getContextId()), Autoboxing.I((int)doc.getId()), Autoboxing.I((int)doc.getVersion()), Autoboxing.L((long)this.getTimestamp())};
    }
}

