/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.AbstractDBAction;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.ObjectPermission;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.AbstractObjectPermissionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class UpdateObjectPermissionAction
extends AbstractObjectPermissionAction {
    private final DocumentMetadata document;
    private final DocumentMetadata oldDocument;

    public UpdateObjectPermissionAction(DBProvider provider, Context context, DocumentMetadata document, DocumentMetadata oldDocument) {
        super(provider, context);
        this.document = document;
        this.oldDocument = oldDocument;
    }

    public void perform() throws OXException {
        ArrayList<AbstractDBAction.UpdateBlock> updates = new ArrayList<AbstractDBAction.UpdateBlock>();
        ObjectPermissionDelta delta = new ObjectPermissionDelta(this.oldDocument.getObjectPermissions(), this.document.getObjectPermissions());
        for (final ObjectPermission removedPermission : delta.removedPermissions) {
            updates.add(new AbstractDBAction.Update("DELETE FROM object_permission WHERE cid=? AND object_id=? AND permission_id=?;"){

                @Override
                public void fillStatement() throws SQLException {
                    this.stmt.setInt(1, UpdateObjectPermissionAction.this.getContext().getContextId());
                    this.stmt.setInt(2, UpdateObjectPermissionAction.this.oldDocument.getId());
                    this.stmt.setInt(3, removedPermission.getEntity());
                }
            });
            updates.add(new AbstractDBAction.Update("REPLACE INTO del_object_permission (cid,permission_id,module,folder_id,object_id,created_by,shared_by,bits,last_modified,group_flag) VALUES (?,?,?,?,?,?,?,?,?,?);"){

                @Override
                public void fillStatement() throws SQLException {
                    this.stmt.setInt(1, UpdateObjectPermissionAction.this.getContext().getContextId());
                    this.stmt.setInt(2, removedPermission.getEntity());
                    this.stmt.setInt(3, 8);
                    this.stmt.setInt(4, (int)UpdateObjectPermissionAction.this.oldDocument.getFolderId());
                    this.stmt.setInt(5, UpdateObjectPermissionAction.this.oldDocument.getId());
                    this.stmt.setInt(6, UpdateObjectPermissionAction.this.oldDocument.getModifiedBy());
                    this.stmt.setInt(7, UpdateObjectPermissionAction.this.oldDocument.getCreatedBy());
                    this.stmt.setInt(8, removedPermission.getPermissions());
                    this.stmt.setLong(9, UpdateObjectPermissionAction.this.document.getLastModified().getTime());
                    this.stmt.setBoolean(10, removedPermission.isGroup());
                }
            });
        }
        for (final ObjectPermission updatedPermission : delta.updatedPermissions) {
            updates.add(new AbstractDBAction.Update("UPDATE object_permission SET created_by=?,shared_by=?,bits=?,last_modified=? WHERE cid=? AND object_id=? AND permission_id=?;"){

                @Override
                public void fillStatement() throws SQLException {
                    this.stmt.setInt(1, UpdateObjectPermissionAction.this.document.getModifiedBy());
                    this.stmt.setInt(2, UpdateObjectPermissionAction.this.document.getCreatedBy());
                    this.stmt.setInt(3, updatedPermission.getPermissions());
                    this.stmt.setLong(4, UpdateObjectPermissionAction.this.document.getLastModified().getTime());
                    this.stmt.setInt(5, UpdateObjectPermissionAction.this.getContext().getContextId());
                    this.stmt.setInt(6, UpdateObjectPermissionAction.this.document.getId());
                    this.stmt.setInt(7, updatedPermission.getEntity());
                }
            });
        }
        for (final ObjectPermission addedPermission : delta.addedPermissions) {
            updates.add(new AbstractDBAction.Update("INSERT INTO object_permission (cid,permission_id,module,folder_id,object_id,created_by,shared_by,bits,last_modified,group_flag) VALUES (?,?,?,?,?,?,?,?,?,?);"){

                @Override
                public void fillStatement() throws SQLException {
                    this.stmt.setInt(1, UpdateObjectPermissionAction.this.getContext().getContextId());
                    this.stmt.setInt(2, addedPermission.getEntity());
                    this.stmt.setInt(3, 8);
                    this.stmt.setInt(4, (int)UpdateObjectPermissionAction.this.document.getFolderId());
                    this.stmt.setInt(5, UpdateObjectPermissionAction.this.document.getId());
                    this.stmt.setInt(6, UpdateObjectPermissionAction.this.document.getModifiedBy());
                    this.stmt.setInt(7, UpdateObjectPermissionAction.this.document.getCreatedBy());
                    this.stmt.setInt(8, addedPermission.getPermissions());
                    this.stmt.setLong(9, UpdateObjectPermissionAction.this.document.getLastModified().getTime());
                    this.stmt.setBoolean(10, addedPermission.isGroup());
                }
            });
        }
        this.doUpdates(updates);
    }

    protected void undoAction() throws OXException {
        ArrayList<AbstractDBAction.UpdateBlock> updates = new ArrayList<AbstractDBAction.UpdateBlock>();
        updates.add(new AbstractDBAction.Update("DELETE FROM object_permission WHERE cid=? AND object_id=?;"){

            @Override
            public void fillStatement() throws SQLException {
                this.stmt.setInt(1, UpdateObjectPermissionAction.this.getContext().getContextId());
                this.stmt.setInt(2, UpdateObjectPermissionAction.this.document.getId());
            }
        });
        List<ObjectPermission> objectPermissions = this.oldDocument.getObjectPermissions();
        if (null != objectPermissions) {
            for (final ObjectPermission objectPermission : objectPermissions) {
                updates.add(new AbstractDBAction.Update("INSERT INTO object_permission (cid,permission_id,module,folder_id,object_id,created_by,shared_by,bits,last_modified,group_flag) VALUES (?,?,?,?,?,?,?,?,?,?);"){

                    @Override
                    public void fillStatement() throws SQLException {
                        this.stmt.setInt(1, UpdateObjectPermissionAction.this.getContext().getContextId());
                        this.stmt.setInt(2, objectPermission.getEntity());
                        this.stmt.setInt(3, 8);
                        this.stmt.setInt(4, (int)UpdateObjectPermissionAction.this.oldDocument.getFolderId());
                        this.stmt.setInt(5, UpdateObjectPermissionAction.this.oldDocument.getId());
                        this.stmt.setInt(6, UpdateObjectPermissionAction.this.oldDocument.getModifiedBy());
                        this.stmt.setInt(7, UpdateObjectPermissionAction.this.oldDocument.getCreatedBy());
                        this.stmt.setInt(8, objectPermission.getPermissions());
                        this.stmt.setLong(9, UpdateObjectPermissionAction.this.oldDocument.getLastModified().getTime());
                        this.stmt.setBoolean(10, objectPermission.isGroup());
                    }
                });
                updates.add(new AbstractDBAction.Update("DELETE FROM del_object_permission WHERE cid=? AND object_id=? AND permission_id=?;"){

                    @Override
                    public void fillStatement() throws SQLException {
                        this.stmt.setInt(1, UpdateObjectPermissionAction.this.getContext().getContextId());
                        this.stmt.setInt(2, UpdateObjectPermissionAction.this.oldDocument.getId());
                        this.stmt.setInt(3, objectPermission.getEntity());
                    }
                });
            }
        }
        this.doUpdates(updates);
    }

    private static class ObjectPermissionDelta {
        final List<ObjectPermission> addedPermissions;
        final List<ObjectPermission> removedPermissions;
        final List<ObjectPermission> updatedPermissions;

        ObjectPermissionDelta(List<ObjectPermission> oldPermissions, List<ObjectPermission> newPermissions) {
            if (null == oldPermissions || 0 == oldPermissions.size()) {
                this.addedPermissions = null == newPermissions ? Collections.emptyList() : newPermissions;
                this.removedPermissions = Collections.emptyList();
                this.updatedPermissions = Collections.emptyList();
            } else if (null == newPermissions || 0 == newPermissions.size()) {
                this.addedPermissions = Collections.emptyList();
                this.removedPermissions = oldPermissions;
                this.updatedPermissions = Collections.emptyList();
            } else {
                ObjectPermission matchingPermission;
                this.addedPermissions = new ArrayList<ObjectPermission>();
                this.updatedPermissions = new ArrayList<ObjectPermission>();
                this.removedPermissions = new ArrayList<ObjectPermission>();
                for (ObjectPermission newPermission : newPermissions) {
                    matchingPermission = ObjectPermissionDelta.findPermission(newPermission.getEntity(), oldPermissions);
                    if (null == matchingPermission) {
                        this.addedPermissions.add(newPermission);
                        continue;
                    }
                    if (matchingPermission.equals(newPermission)) continue;
                    this.updatedPermissions.add(newPermission);
                }
                for (ObjectPermission oldPermission : oldPermissions) {
                    matchingPermission = ObjectPermissionDelta.findPermission(oldPermission.getEntity(), newPermissions);
                    if (null != matchingPermission) continue;
                    this.removedPermissions.add(oldPermission);
                }
            }
        }

        private static ObjectPermission findPermission(int entity, Collection<ObjectPermission> permissions) {
            if (null != permissions) {
                for (ObjectPermission permission : permissions) {
                    if (permission.getEntity() != entity) continue;
                    return permission;
                }
            }
            return null;
        }
    }
}

