/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.EffectiveObjectPermission;
import com.openexchange.groupware.container.EffectiveObjectPermissions;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.ObjectPermission;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.EffectiveInfostoreFolderPermission;
import com.openexchange.groupware.infostore.EffectiveInfostorePermission;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.InfostoreIterator;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurity;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.util.Pair;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.tools.collections.Injector;
import com.openexchange.tools.collections.OXCollections;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.list.array.TIntArrayList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfostoreSecurityImpl
extends DBService
implements InfostoreSecurity {
    public static int getFolderOwner(FolderObject folder) {
        return null == folder ? -1 : folder.getCreatedBy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFolderOwner(long folderId, Context ctx) throws OXException {
        Connection readCon = null;
        try {
            readCon = this.getReadConnection(ctx);
            OXFolderAccess folderAccess = new OXFolderAccess(readCon, ctx);
            int n = InfostoreSecurityImpl.getFolderOwner(folderAccess.getFolderObject((int)folderId));
            return n;
        }
        finally {
            this.releaseReadConnection(ctx, readCon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getFolderOwners(Collection<DocumentMetadata> documents, Context ctx) throws OXException {
        Connection readCon = null;
        try {
            readCon = this.getReadConnection(ctx);
            OXFolderAccess folderAccess = new OXFolderAccess(readCon, ctx);
            TIntArrayList admins = new TIntArrayList();
            for (DocumentMetadata document : documents) {
                FolderObject folder = folderAccess.getFolderObject((int)document.getFolderId());
                admins.add(InfostoreSecurityImpl.getFolderOwner(folder));
            }
            int[] nArray = admins.toArray();
            return nArray;
        }
        finally {
            this.releaseReadConnection(ctx, readCon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFolderOwner(DocumentMetadata document, Context ctx) throws OXException {
        Connection readCon = null;
        try {
            readCon = this.getReadConnection(ctx);
            OXFolderAccess folderAccess = new OXFolderAccess(readCon, ctx);
            FolderObject folder = folderAccess.getFolderObject((int)document.getFolderId());
            int n = InfostoreSecurityImpl.getFolderOwner(folder);
            return n;
        }
        finally {
            this.releaseReadConnection(ctx, readCon);
        }
    }

    @Override
    public EffectiveInfostorePermission getInfostorePermission(ServerSession session, int id) throws OXException {
        List<DocumentMetadata> documents = this.getFolderIdAndCreatorForDocuments(new int[]{id}, session.getContext());
        if (documents == null || documents.size() <= 0 || documents.get(0) == null) {
            throw InfostoreExceptionCodes.NOT_EXIST.create();
        }
        return this.getInfostorePermission(session, documents.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EffectiveInfostorePermission getInfostorePermission(Context context, User user, UserPermissionBits userPermissions, int id) throws OXException {
        List<DocumentMetadata> documents = this.getFolderIdAndCreatorForDocuments(new int[]{id}, context);
        if (documents == null || documents.size() <= 0 || documents.get(0) == null) {
            throw InfostoreExceptionCodes.NOT_EXIST.create();
        }
        DocumentMetadata document = documents.iterator().next();
        Connection connection = null;
        try {
            connection = this.getReadConnection(context);
            OXFolderAccess folderAccess = new OXFolderAccess(connection, context);
            FolderObject folder = folderAccess.getFolderObject((int)document.getFolderId());
            EffectivePermission isperm = folder.getEffectiveUserPermission(user.getId(), userPermissions);
            EffectiveObjectPermission effectiveObjectPermission = InfostoreSecurityImpl.getEffectiveObjectPermission(context, user, userPermissions, document, connection);
            EffectiveInfostorePermission effectiveInfostorePermission = new EffectiveInfostorePermission(isperm, effectiveObjectPermission, document, user, InfostoreSecurityImpl.getFolderOwner(folder));
            return effectiveInfostorePermission;
        }
        finally {
            this.releaseReadConnection(context, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EffectiveInfostorePermission getInfostorePermission(ServerSession session, DocumentMetadata document) throws OXException {
        Connection connection = null;
        try {
            connection = this.getReadConnection(session.getContext());
            OXFolderAccess folderAccess = new OXFolderAccess(connection, session.getContext());
            FolderObject folder = folderAccess.getFolderObject((int)document.getFolderId());
            EffectivePermission isperm = folder.getEffectiveUserPermission(session.getUserId(), session.getUserPermissionBits());
            EffectiveObjectPermission effectiveObjectPermission = InfostoreSecurityImpl.getEffectiveObjectPermission(session, document, connection);
            EffectiveInfostorePermission effectiveInfostorePermission = new EffectiveInfostorePermission(isperm, effectiveObjectPermission, document, session.getUser(), InfostoreSecurityImpl.getFolderOwner(folder));
            return effectiveInfostorePermission;
        }
        finally {
            this.releaseReadConnection(session.getContext(), connection);
        }
    }

    @Override
    public List<EffectiveInfostorePermission> getInfostorePermissions(List<DocumentMetadata> documents, Context ctx, User user, UserPermissionBits userPermissions) throws OXException {
        return this.getInfostorePermissions0(documents, ctx, user, userPermissions);
    }

    @Override
    public EffectiveInfostoreFolderPermission getFolderPermission(ServerSession session, long folderId) throws OXException {
        return this.getFolderPermission(folderId, session.getContext(), session.getUser(), session.getUserPermissionBits());
    }

    @Override
    public EffectiveInfostoreFolderPermission getFolderPermission(long folderId, Context ctx, User user, UserPermissionBits userPermissions) throws OXException {
        return this.getFolderPermission(folderId, ctx, user, userPermissions, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EffectiveInfostoreFolderPermission getFolderPermission(long folderId, Context ctx, User user, UserPermissionBits userPermissions, Connection readConArg) throws OXException {
        Connection readCon = null;
        try {
            readCon = this.getReadConnection(ctx);
            OXFolderAccess folderAccess = new OXFolderAccess(readCon, ctx);
            FolderObject folder = folderAccess.getFolderObject((int)folderId);
            EffectivePermission isperm = folder.getEffectiveUserPermission(user.getId(), userPermissions);
            EffectiveInfostoreFolderPermission effectiveInfostoreFolderPermission = new EffectiveInfostoreFolderPermission(isperm, InfostoreSecurityImpl.getFolderOwner(folder));
            return effectiveInfostoreFolderPermission;
        }
        finally {
            this.releaseReadConnection(ctx, readCon);
        }
    }

    @Override
    public <L> L injectInfostorePermissions(int[] ids, Context ctx, User user, UserPermissionBits userPermissions, L list, Injector<L, EffectiveInfostorePermission> injector) throws OXException {
        List<DocumentMetadata> metadata = this.getFolderIdAndCreatorForDocuments(ids, ctx);
        List<EffectiveInfostorePermission> infostorePermissions = this.getInfostorePermissions0(metadata, ctx, user, userPermissions);
        return OXCollections.inject(list, infostorePermissions, injector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DocumentMetadata> getFolderIdAndCreatorForDocuments(int[] ids, Context context) throws OXException {
        List<DocumentMetadata> list;
        Metadata[] metadata = new Metadata[]{Metadata.FOLDER_ID_LITERAL, Metadata.ID_LITERAL, Metadata.CREATED_BY_LITERAL};
        InfostoreIterator searchIterator = null;
        try {
            searchIterator = InfostoreIterator.list(ids, metadata, this, context);
            list = searchIterator.asList();
        }
        catch (Throwable throwable) {
            SearchIterators.close(searchIterator);
            throw throwable;
        }
        SearchIterators.close((SearchIterator)searchIterator);
        return list;
    }

    private List<EffectiveInfostorePermission> getInfostorePermissions0(List<DocumentMetadata> documents, Context ctx, User user, UserPermissionBits userPermissions) throws OXException {
        Connection con = this.getReadConnection(ctx);
        try {
            FolderObject folder;
            EffectivePermission folderPermission;
            OXFolderAccess oxFolderAccess = new OXFolderAccess(con, ctx);
            HashMap<Long, EffectivePermission> folderPermissions = new HashMap<Long, EffectivePermission>(documents.size() * 2);
            HashMap<Long, FolderObject> folders2 = new HashMap<Long, FolderObject>(documents.size() * 2);
            ArrayList<Pair<Integer, Integer>> foldersAndDocuments = new ArrayList<Pair<Integer, Integer>>(documents.size());
            Map<Object, Object> objectPermissionsByFolder = new HashMap();
            for (DocumentMetadata document : documents) {
                long folderId = document.getFolderId();
                EffectiveObjectPermission effectiveObjectPermission = null;
                ObjectPermission objectPermission = EffectiveObjectPermissions.find(user, document.getObjectPermissions());
                if (objectPermission != null) {
                    effectiveObjectPermission = EffectiveObjectPermissions.convert(8, (int)document.getFolderId(), document.getId(), objectPermission, userPermissions);
                }
                if (effectiveObjectPermission == null) {
                    foldersAndDocuments.add((Pair<Integer, Integer>)new Pair((Object)((int)folderId), (Object)document.getId()));
                } else {
                    HashMap<Integer, EffectiveObjectPermission> permissionsByDocument = (HashMap<Integer, EffectiveObjectPermission>)objectPermissionsByFolder.get((int)folderId);
                    if (permissionsByDocument == null) {
                        permissionsByDocument = new HashMap<Integer, EffectiveObjectPermission>();
                        objectPermissionsByFolder.put((int)folderId, permissionsByDocument);
                    }
                    permissionsByDocument.put(document.getId(), effectiveObjectPermission);
                }
                if ((folderPermission = (EffectivePermission)folderPermissions.get(folderId)) != null) continue;
                folder = oxFolderAccess.getFolderObject((int)folderId);
                folderPermission = folder.getEffectiveUserPermission(user.getId(), userPermissions, con);
                folderPermissions.put(folderId, folderPermission);
                folders2.put(folderId, folder);
            }
            Map<Integer, Map<Integer, EffectiveObjectPermission>> objectPermissionsByFolderFromDB = EffectiveObjectPermissions.load(ctx, user, userPermissions, 8, foldersAndDocuments, con);
            if (!objectPermissionsByFolderFromDB.isEmpty()) {
                if (objectPermissionsByFolder.isEmpty()) {
                    objectPermissionsByFolder = objectPermissionsByFolderFromDB;
                } else {
                    List<EffectiveObjectPermission> objectPermissions = EffectiveObjectPermissions.flatten(objectPermissionsByFolderFromDB);
                    for (EffectiveObjectPermission permission : objectPermissions) {
                        int folderId = permission.getFolderId();
                        HashMap<Integer, EffectiveObjectPermission> permissionsByDocument = (HashMap<Integer, EffectiveObjectPermission>)objectPermissionsByFolder.get(folderId);
                        if (permissionsByDocument == null) {
                            permissionsByDocument = new HashMap<Integer, EffectiveObjectPermission>();
                            objectPermissionsByFolder.put(folderId, permissionsByDocument);
                        }
                        permissionsByDocument.put(permission.getObjectId(), permission);
                    }
                }
            }
            ArrayList<EffectiveInfostorePermission> permissions = new ArrayList<EffectiveInfostorePermission>(documents.size());
            for (DocumentMetadata document : documents) {
                long folderId = document.getFolderId();
                folderPermission = (EffectivePermission)folderPermissions.get(folderId);
                folder = (FolderObject)folders2.get(folderId);
                EffectiveObjectPermission objectPermission = null;
                Map objectPermissionsByDocument = (Map)objectPermissionsByFolder.get((int)folderId);
                if (objectPermissionsByDocument != null) {
                    objectPermission = (EffectiveObjectPermission)objectPermissionsByDocument.get(document.getId());
                }
                permissions.add(new EffectiveInfostorePermission(folderPermission, objectPermission, document, user, InfostoreSecurityImpl.getFolderOwner(folder)));
            }
            ArrayList<EffectiveInfostorePermission> arrayList = permissions;
            return arrayList;
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            this.releaseReadConnection(ctx, con);
        }
    }

    private static EffectiveObjectPermission getEffectiveObjectPermission(ServerSession session, DocumentMetadata document, Connection con) throws OXException {
        ObjectPermission objectPermission = EffectiveObjectPermissions.find(session.getUser(), document.getObjectPermissions());
        if (objectPermission != null) {
            return EffectiveObjectPermissions.convert(8, (int)document.getFolderId(), document.getId(), objectPermission, session.getUserPermissionBits());
        }
        return EffectiveObjectPermissions.load(session, 8, (int)document.getFolderId(), document.getId(), con);
    }

    private static EffectiveObjectPermission getEffectiveObjectPermission(Context context, User user, UserPermissionBits permissionBits, DocumentMetadata document, Connection con) throws OXException {
        ObjectPermission objectPermission = EffectiveObjectPermissions.find(user, document.getObjectPermissions());
        if (objectPermission != null) {
            return EffectiveObjectPermissions.convert(8, (int)document.getFolderId(), document.getId(), objectPermission, permissionBits);
        }
        return EffectiveObjectPermissions.load(context, user, permissionBits, 8, (int)document.getFolderId(), document.getId(), con);
    }
}

