/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.filestore;

import com.openexchange.database.Databases;
import com.openexchange.groupware.filestore.FileLocationHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractFileLocationHandler
implements FileLocationHandler {
    protected static final int IN_LIMIT = 1000;

    protected AbstractFileLocationHandler() {
    }

    protected static String getSqlInStringFor(int size) {
        StringBuilder sb = new StringBuilder(size << 1);
        sb.append("(?");
        int i = size - 1;
        while (i-- > 0) {
            sb.append(", ?");
        }
        sb.append(')');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateFileLocationsUsing(Map<String, String> prevFileName2newFileName, int contextId, String selectStmt, String updateStmt, Connection con) throws SQLException {
        int size = prevFileName2newFileName.size();
        if (size <= 0) {
            return;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Iterator<String> allPrevFileNames = prevFileName2newFileName.keySet().iterator();
            for (int i = 0; i < size; i += 1000) {
                int chunkSizeSize = i + 1000 > size ? size - i : 1000;
                ArrayList<String> chunkPrevFileNames = new ArrayList<String>(chunkSizeSize);
                int j = chunkSizeSize;
                while (j-- > 0) {
                    chunkPrevFileNames.add(allPrevFileNames.next());
                }
                stmt = con.prepareStatement(selectStmt + AbstractFileLocationHandler.getSqlInStringFor(chunkSizeSize));
                int pos = 0;
                stmt.setInt(++pos, contextId);
                Iterator chunkIter = chunkPrevFileNames.iterator();
                int j2 = chunkSizeSize;
                while (j2-- > 0) {
                    stmt.setString(++pos, (String)chunkIter.next());
                }
                rs = stmt.executeQuery();
                if (rs.next()) {
                    ArrayList<String> existent = chunkPrevFileNames;
                    existent.clear();
                    chunkPrevFileNames = null;
                    do {
                        existent.add(rs.getString(1));
                    } while (rs.next());
                    Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                    rs = null;
                    stmt = con.prepareStatement(updateStmt);
                    for (String prevFileName : existent) {
                        String newFileName = prevFileName2newFileName.get(prevFileName);
                        stmt.setString(1, newFileName);
                        stmt.setInt(2, contextId);
                        stmt.setString(3, prevFileName);
                        stmt.addBatch();
                    }
                    stmt.executeBatch();
                }
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            }
        }
        finally {
            Databases.closeSQLStuff(rs, stmt);
        }
    }
}

