/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.delete;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import java.util.EventObject;

public class DeleteEvent
extends EventObject {
    public static final int TYPE_USER = 1;
    public static final int TYPE_GROUP = 2;
    public static final int TYPE_RESOURCE = 3;
    public static final int TYPE_RESOURCE_GROUP = 4;
    public static final int TYPE_CONTEXT = 5;
    public static final int SUBTYPE_ANONYMOUS_GUEST = 101;
    public static final int SUBTYPE_INVITED_GUEST = 102;
    private static final long serialVersionUID = 2636570955675454470L;
    private final transient Context ctx;
    protected int id;
    protected int type;
    protected int subType;
    protected Integer destUserID;
    private transient Session session;

    public DeleteEvent(Object source, int id, int type, int cid) throws OXException {
        this(source, id, type, ContextStorage.getInstance().getContext(cid));
    }

    public DeleteEvent(Object source, int id, int type, Context ctx) {
        this(source, id, type, 0, ctx, null);
    }

    public DeleteEvent(Object source, int id, int type, int subType, Context ctx, Integer destUserID) {
        super(source);
        this.id = id;
        this.type = type;
        this.subType = subType;
        this.ctx = ctx;
        this.destUserID = destUserID;
    }

    public Context getContext() {
        return this.ctx;
    }

    public int getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public int getSubType() {
        return this.subType;
    }

    public Session getSession() {
        if (this.session == null) {
            this.session = SessionObjectWrapper.createSessionObject(this.ctx.getMailadmin(), this.ctx, "DeleteEventSessionObject");
        }
        return this.session;
    }

    public Integer getDestinationUserID() {
        return this.destUserID;
    }
}

