/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class SystemObject
implements Serializable {
    private static final long serialVersionUID = 5804496798486123299L;
    protected transient Map<String, Object> map;
    protected boolean b_map;
    private Map<String, Serializable> serializableMap = null;

    protected SystemObject() {
    }

    public void setProperty(String name, Object value) {
        if (null == name || null == value) {
            return;
        }
        Map<String, Object> map = this.map;
        if (null == map) {
            this.map = map = new LinkedHashMap<String, Object>(12);
            this.b_map = true;
        }
        map.put(name, value);
    }

    public <V> V getProperty(String name) {
        if (null == name) {
            return null;
        }
        Map<String, Object> map = this.map;
        if (null == map) {
            return null;
        }
        try {
            return (V)map.get(name);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public <V> V removeProperty(String name) {
        if (null == name) {
            return null;
        }
        Map<String, Object> map = this.map;
        if (null == map) {
            return null;
        }
        try {
            return (V)map.remove(name);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public void setMap(Map<String, ? extends Object> map) {
        this.map = null == map ? null : new LinkedHashMap<String, Object>(map);
        this.b_map = true;
    }

    public void removeMap() {
        this.map = null;
        this.b_map = false;
    }

    public boolean containsMap() {
        return this.b_map;
    }

    public Map<String, Object> getMap() {
        return null == this.map ? null : Collections.unmodifiableMap(this.map);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Map<String, Object> map = this.map;
        if (null == map) {
            this.serializableMap = null;
        } else {
            LinkedHashMap<String, Serializable> serializableMap = new LinkedHashMap<String, Serializable>(map.size());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof Serializable)) continue;
                serializableMap.put(key, (Serializable)value);
            }
            this.serializableMap = serializableMap;
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.readObject();
        Map<String, Serializable> serializableMap = this.serializableMap;
        this.map = null == serializableMap ? null : new LinkedHashMap<String, Serializable>(serializableMap);
        this.serializableMap = null;
    }
}

