/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.EffectiveObjectPermission;
import com.openexchange.groupware.container.ObjectPermission;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Strings;
import com.openexchange.java.util.Pair;
import com.openexchange.osgi.util.ServiceCallWrapper;
import com.openexchange.tools.session.ServerSession;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EffectiveObjectPermissions {
    private EffectiveObjectPermissions() {
    }

    public static ObjectPermission find(User user, Collection<ObjectPermission> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return null;
        }
        int userId = user.getId();
        HashSet<Integer> groups = new HashSet<Integer>();
        int[] tmp = user.getGroups();
        if (tmp != null) {
            for (int group : tmp) {
                groups.add(group);
            }
        }
        ObjectPermission found = null;
        for (ObjectPermission permission : permissions) {
            boolean checkAndSet = false;
            int entity = permission.getEntity();
            if (permission.isGroup()) {
                if (groups.contains(entity)) {
                    checkAndSet = true;
                }
            } else if (entity == userId) {
                checkAndSet = true;
            }
            if (!checkAndSet || found != null && found.getPermissions() >= permission.getPermissions()) continue;
            found = permission;
        }
        return found;
    }

    public static EffectiveObjectPermission convert(int module, int folderId, int id, ObjectPermission permission, UserPermissionBits permissionBits) {
        return new EffectiveObjectPermission(module, folderId, id, permission, permissionBits);
    }

    public static EffectiveObjectPermission load(ServerSession session, int module, int folderId, int id) throws OXException {
        return EffectiveObjectPermissions.load(session.getContext(), session.getUser(), session.getUserPermissionBits(), module, folderId, id);
    }

    public static EffectiveObjectPermission load(ServerSession session, int module, int folderId, int id, Connection con) throws OXException {
        return EffectiveObjectPermissions.load(session.getContext(), session.getUser(), session.getUserPermissionBits(), module, folderId, id, con);
    }

    public static EffectiveObjectPermission load(final Context ctx, final User user, final UserPermissionBits permissionBits, final int module, final int folderId, final int id) throws OXException {
        try {
            return (EffectiveObjectPermission)ServiceCallWrapper.doServiceCall(EffectiveObjectPermissions.class, DatabaseService.class, (ServiceCallWrapper.ServiceUser)new ServiceCallWrapper.ServiceUser<DatabaseService, EffectiveObjectPermission>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public EffectiveObjectPermission call(DatabaseService service) throws Exception {
                    Connection con = null;
                    try {
                        con = service.getReadOnly(ctx);
                        EffectiveObjectPermission effectiveObjectPermission = EffectiveObjectPermissions.load(ctx, user, permissionBits, module, folderId, id, con);
                        return effectiveObjectPermission;
                    }
                    finally {
                        if (con != null) {
                            service.backReadOnly(ctx, con);
                        }
                    }
                }
            });
        }
        catch (ServiceCallWrapper.ServiceException e) {
            throw e.toOXException();
        }
    }

    public static EffectiveObjectPermission load(Context ctx, User user, UserPermissionBits permissionBits, int module, int folderId, int id, Connection con) throws OXException {
        if (null == con) {
            return EffectiveObjectPermissions.load(ctx, user, permissionBits, module, folderId, id);
        }
        StringBuilder sb = new StringBuilder(128).append("SELECT bits, permission_id, group_flag FROM object_permission WHERE cid = ").append(ctx.getContextId()).append(" AND module = ").append(module);
        sb.append(" AND folder_id = ").append(folderId).append(" AND object_id = ").append(id);
        EffectiveObjectPermissions.appendEntityConstraint(sb, user.getId(), user.getGroups());
        Statement stmt = null;
        ResultSet rs = null;
        ObjectPermission permission = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(sb.toString());
            while (rs.next()) {
                int bits = rs.getInt(1);
                if (permission != null && bits <= permission.getPermissions()) continue;
                permission = new ObjectPermission(rs.getInt(2), rs.getBoolean(3), bits);
            }
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e.getMessage());
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        if (permission == null) {
            return null;
        }
        return new EffectiveObjectPermission(module, folderId, id, permission, permissionBits);
    }

    public static Map<Integer, Map<Integer, EffectiveObjectPermission>> load(Context ctx, User user, UserPermissionBits permissionBits, int module, List<Pair<Integer, Integer>> folderAndObjectIds, Connection con) throws OXException {
        if (folderAndObjectIds.isEmpty()) {
            return new HashMap<Integer, Map<Integer, EffectiveObjectPermission>>();
        }
        HashMap<Integer, ArrayList<Integer>> objectIdsByFolder = new HashMap<Integer, ArrayList<Integer>>(folderAndObjectIds.size());
        for (Pair<Integer, Integer> folderAndObjectId : folderAndObjectIds) {
            Integer folderId = (Integer)folderAndObjectId.getFirst();
            Integer objectId = (Integer)folderAndObjectId.getSecond();
            ArrayList<Integer> objectIds = (ArrayList<Integer>)objectIdsByFolder.get(folderId);
            if (objectIds == null) {
                objectIds = new ArrayList<Integer>();
                objectIdsByFolder.put(folderId, objectIds);
            }
            objectIds.add(objectId);
        }
        StringBuilder sb = new StringBuilder(128).append("SELECT folder_id, object_id, bits, permission_id, group_flag FROM object_permission WHERE cid = ").append(ctx.getContextId()).append(" AND module = ").append(module);
        sb.append(" AND (");
        for (Map.Entry entry : objectIdsByFolder.entrySet()) {
            sb.append("(folder_id = ").append(entry.getKey()).append(" AND object_id IN (");
            Strings.join((Collection)((Collection)entry.getValue()), (String)", ", (StringBuilder)sb);
            sb.append("))");
            sb.append(" OR ");
        }
        sb.setLength(sb.length() - " OR ".length());
        sb.append(")");
        EffectiveObjectPermissions.appendEntityConstraint(sb, user.getId(), user.getGroups());
        HashMap<Integer, Map<Integer, EffectiveObjectPermission>> gatheredPermissions = new HashMap<Integer, Map<Integer, EffectiveObjectPermission>>(objectIdsByFolder.size());
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(sb.toString());
            while (rs.next()) {
                EffectiveObjectPermission permission;
                int folderId = rs.getInt(1);
                int objectId = rs.getInt(2);
                int bits = rs.getInt(3);
                HashMap<Integer, EffectiveObjectPermission> permissionsInFolder = (HashMap<Integer, EffectiveObjectPermission>)gatheredPermissions.get(folderId);
                if (permissionsInFolder == null) {
                    permissionsInFolder = new HashMap<Integer, EffectiveObjectPermission>();
                    gatheredPermissions.put(folderId, permissionsInFolder);
                }
                if ((permission = (EffectiveObjectPermission)permissionsInFolder.get(objectId)) != null && bits <= permission.getPermission().getPermissions()) continue;
                permissionsInFolder.put(objectId, new EffectiveObjectPermission(module, folderId, objectId, new ObjectPermission(rs.getInt(4), rs.getBoolean(5), bits), permissionBits));
            }
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e.getMessage());
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return gatheredPermissions;
    }

    public static List<EffectiveObjectPermission> flatten(Map<Integer, Map<Integer, EffectiveObjectPermission>> permissions) {
        ArrayList<EffectiveObjectPermission> permissionList = new ArrayList<EffectiveObjectPermission>();
        for (Map<Integer, EffectiveObjectPermission> value : permissions.values()) {
            for (EffectiveObjectPermission inner : value.values()) {
                permissionList.add(inner);
            }
        }
        return permissionList;
    }

    private static void appendEntityConstraint(StringBuilder sb, int userId, int[] groups) {
        if (groups != null && groups.length > 0) {
            sb.append(" AND ((").append("group_flag <> 1 AND permission_id = ").append(userId).append(") OR (group_flag = 1 AND permission_id IN (");
            Strings.join((int[])groups, (String)", ", (StringBuilder)sb);
            sb.append(")))");
        } else {
            sb.append(" AND (group_flag <> 1 AND permission_id = ").append(userId).append(")");
        }
    }
}

