/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.groupware.container.ObjectPermission;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;

public class EffectiveObjectPermission {
    private final int module;
    private final int folderId;
    private final int objectId;
    private final ObjectPermission permission;
    private final UserPermissionBits permissionBits;

    public EffectiveObjectPermission(int module, int folderId, int objectId, ObjectPermission permission, UserPermissionBits permissionBits) {
        this.module = module;
        this.folderId = folderId;
        this.objectId = objectId;
        this.permission = permission;
        this.permissionBits = permissionBits;
    }

    public boolean canRead() {
        return this.hasModulePermission() && this.permission.canRead();
    }

    public boolean canNotRead() {
        return !this.canRead();
    }

    public boolean canWrite() {
        return this.hasModulePermission() && this.permission.canWrite();
    }

    public boolean canNotWrite() {
        return !this.canWrite();
    }

    public boolean canDelete() {
        return this.hasModulePermission() && this.permission.canDelete();
    }

    public boolean canNotDelete() {
        return !this.canDelete();
    }

    public int getModule() {
        return this.module;
    }

    public int getFolderId() {
        return this.folderId;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public ObjectPermission getPermission() {
        return this.permission;
    }

    public boolean canShare() {
        return this.canWrite() && this.permissionBits.hasFullSharedFolderAccess();
    }

    private boolean hasModulePermission() {
        return this.permissionBits.hasModuleAccess(this.module);
    }
}

