/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.groupware.container.Contact;
import com.openexchange.search.SearchAttributeFetcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactAttributeFetcher
implements SearchAttributeFetcher<Contact> {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeGetter.class);
    private static final Map<String, AttributeGetter> GETTERS;
    private static final ContactAttributeFetcher instance;

    public static ContactAttributeFetcher getInstance() {
        return instance;
    }

    private ContactAttributeFetcher() {
    }

    public <T> T getAttribute(String attributeName, Contact candidate) {
        AttributeGetter getter = GETTERS.get(attributeName);
        if (null == getter) {
            LOG.info("No getter for field: {}", (Object)attributeName);
            return null;
        }
        return (T)getter.getObject(candidate);
    }

    static {
        HashMap<String, AttributeGetter> m = new HashMap<String, AttributeGetter>(25);
        m.put("anniversary", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getAnniversary();
            }
        });
        m.put("assistant_name", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getAssistantName();
            }
        });
        m.put("birthday", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getBirthday();
            }
        });
        m.put("branches", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getBranches();
            }
        });
        m.put("busines_categorie", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getBusinessCategory();
            }
        });
        m.put("cellular_telephone1", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getCellularTelephone1();
            }
        });
        m.put("cellular_telephone2", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getCellularTelephone2();
            }
        });
        m.put("city_business", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getCityBusiness();
            }
        });
        m.put("city_home", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getCityHome();
            }
        });
        m.put("city_other", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getCityOther();
            }
        });
        m.put("commercial_register", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getCommercialRegister();
            }
        });
        m.put("company", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getCompany();
            }
        });
        m.put("country_business", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getCountryBusiness();
            }
        });
        m.put("country_home", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getCountryHome();
            }
        });
        m.put("country_other", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getCountryOther();
            }
        });
        m.put("department", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getDepartment();
            }
        });
        m.put("display_name", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getDisplayName();
            }
        });
        m.put("distribution_list", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getDistributionList();
            }
        });
        m.put("email1", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getEmail1();
            }
        });
        m.put("email2", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getEmail2();
            }
        });
        m.put("email3", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getEmail3();
            }
        });
        m.put("employee_type", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getEmployeeType();
            }
        });
        m.put("fax_business", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getFaxBusiness();
            }
        });
        m.put("fax_home", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getFaxHome();
            }
        });
        m.put("fax_other", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getFaxOther();
            }
        });
        m.put("first_name", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getGivenName();
            }
        });
        m.put("info", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getInfo();
            }
        });
        m.put("instant_messenger1", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getInstantMessenger1();
            }
        });
        m.put("instant_messenger2", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getInstantMessenger2();
            }
        });
        m.put("last_name", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getSurName();
            }
        });
        m.put("manager_name", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getManagerName();
            }
        });
        m.put("marital_status", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getMaritalStatus();
            }
        });
        m.put("nickname", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getNickname();
            }
        });
        m.put("note", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getNote();
            }
        });
        m.put("number_of_children", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getNumberOfChildren();
            }
        });
        m.put("number_of_employees", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getNumberOfEmployee();
            }
        });
        m.put("position", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getPosition();
            }
        });
        m.put("postal_code_business", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getPostalCodeBusiness();
            }
        });
        m.put("postal_code_home", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getPostalCodeHome();
            }
        });
        m.put("postal_code_other", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getPostalCodeOther();
            }
        });
        m.put("profession", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getProfession();
            }
        });
        m.put("room_number", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getRoomNumber();
            }
        });
        m.put("sales_volume", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getSalesVolume();
            }
        });
        m.put("second_name", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getMiddleName();
            }
        });
        m.put("spouse_name", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getSpouseName();
            }
        });
        m.put("state_business", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getStateBusiness();
            }
        });
        m.put("state_home", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getStateHome();
            }
        });
        m.put("state_other", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getStreetOther();
            }
        });
        m.put("street_business", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getStreetBusiness();
            }
        });
        m.put("street_home", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getStreetHome();
            }
        });
        m.put("street_other", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getStreetOther();
            }
        });
        m.put("suffix", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getSuffix();
            }
        });
        m.put("tax_id", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTaxID();
            }
        });
        m.put("telephone_assistant", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneAssistant();
            }
        });
        m.put("telephone_business1", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneBusiness1();
            }
        });
        m.put("telephone_business2", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneBusiness2();
            }
        });
        m.put("telephone_callback", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneCallback();
            }
        });
        m.put("telephone_car", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneCar();
            }
        });
        m.put("telephone_company", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneCompany();
            }
        });
        m.put("telephone_home1", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneHome1();
            }
        });
        m.put("telephone_home2", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneHome2();
            }
        });
        m.put("telephone_ip", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneIP();
            }
        });
        m.put("telephone_isdn", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneISDN();
            }
        });
        m.put("telephone_other", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneOther();
            }
        });
        m.put("telephone_pager", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephonePager();
            }
        });
        m.put("telephone_primary", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephonePrimary();
            }
        });
        m.put("telephone_radio", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneRadio();
            }
        });
        m.put("telephone_telex", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneTelex();
            }
        });
        m.put("telephone_ttytdd", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTelephoneTTYTTD();
            }
        });
        m.put("title", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getTitle();
            }
        });
        m.put("url", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getURL();
            }
        });
        m.put("user_id", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getInternalUserId();
            }
        });
        m.put("categories", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getCategories();
            }
        });
        m.put("color_label", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getLabel();
            }
        });
        m.put("created_by", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getCreatedBy();
            }
        });
        m.put("creation_date", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getCreationDate();
            }
        });
        m.put("folder_id", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getParentFolderID();
            }
        });
        m.put("id", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getObjectID();
            }
        });
        m.put("last_modified", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getLastModified();
            }
        });
        m.put("modified_by", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getModifiedBy();
            }
        });
        m.put("private_flag", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getPrivateFlag();
            }
        });
        m.put("extended_properties", new AttributeGetter(){

            @Override
            public Object getObject(Contact candidate) {
                return candidate.getExtendedProperties();
            }
        });
        GETTERS = Collections.unmodifiableMap(m);
        instance = new ContactAttributeFetcher();
    }

    private static interface AttributeGetter {
        public Object getObject(Contact var1);
    }
}

