/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.json.resultconverter;

import com.openexchange.ajax.anonymizer.AnonymizerService;
import com.openexchange.ajax.anonymizer.Anonymizers;
import com.openexchange.ajax.anonymizer.Module;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.writer.GroupWriter;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.groupware.results.CollectionDelta;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GroupJsonResultConverter
implements ResultConverter {
    @Override
    public String getInputFormat() {
        return "group";
    }

    @Override
    public String getOutputFormat() {
        return "json";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        try {
            this.convert(requestData, result, session);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException, JSONException {
        Object resultObject = result.getResultObject();
        if (resultObject instanceof Group) {
            Group group = (Group)resultObject;
            Anonymizers.optAnonymizeIfGuest(group, Module.GROUP, session);
            JSONObject jGroup = new JSONObject(6);
            new GroupWriter().writeGroup(group, jGroup);
            result.setResultObject(jGroup, "json");
        } else if (resultObject instanceof CollectionDelta) {
            JSONArray jDeletedGroups;
            List deleted;
            CollectionDelta collectionDelta = (CollectionDelta)resultObject;
            List groups = collectionDelta.getNewAndModified();
            JSONArray jGroups = new JSONArray(groups.size());
            GroupWriter groupWriter = new GroupWriter();
            if (Anonymizers.isGuest(session)) {
                AnonymizerService<Group> anonymizer = Anonymizers.optAnonymizerFor(Module.GROUP);
                for (Group group : groups) {
                    group = anonymizer.anonymize(group, session);
                    JSONObject jGroup = new JSONObject(6);
                    groupWriter.writeGroup(group, jGroup);
                    jGroups.put((Object)jGroup);
                }
            } else {
                for (Group group : groups) {
                    JSONObject jGroup = new JSONObject(6);
                    groupWriter.writeGroup(group, jGroup);
                    jGroups.put((Object)jGroup);
                }
            }
            if (null == (deleted = collectionDelta.getDeleted())) {
                jDeletedGroups = new JSONArray(0);
            } else {
                jDeletedGroups = new JSONArray(deleted.size());
                if (Anonymizers.isGuest(session)) {
                    AnonymizerService<Group> anonymizer = Anonymizers.optAnonymizerFor(Module.GROUP);
                    for (Group group : deleted) {
                        group = anonymizer.anonymize(group, session);
                        JSONObject jGroup = new JSONObject(6);
                        groupWriter.writeGroup(group, jGroup);
                        jDeletedGroups.put((Object)jGroup);
                    }
                } else {
                    for (Group group : deleted) {
                        JSONObject jGroup = new JSONObject(6);
                        groupWriter.writeGroup(group, jGroup);
                        jDeletedGroups.put((Object)jGroup);
                    }
                }
            }
            JSONObject jResult = new JSONObject(3);
            jResult.put("new", (Object)jGroups).put("modified", (Object)jGroups);
            jResult.put("deleted", (Object)jDeletedGroups);
            result.setResultObject(jResult, "json");
        } else if ("all".equalsIgnoreCase(requestData.getAction())) {
            Collection groups = (Collection)resultObject;
            int[] columns = requestData.checkIntArray("columns");
            boolean loadMembers = false;
            LinkedList<Group.Field> fields = new LinkedList<Group.Field>();
            for (int column : columns) {
                Group.Field field = Group.Field.getByColumnNumber(column);
                if (field == Group.Field.MEMBERS) {
                    loadMembers = true;
                }
                fields.add(field);
            }
            JSONArray jGroupRows = new JSONArray(groups.size());
            GroupWriter groupWriter = new GroupWriter();
            if (Anonymizers.isGuest(session)) {
                AnonymizerService<Group> anonymizer = Anonymizers.optAnonymizerFor(Module.GROUP);
                for (Group group : groups) {
                    group = anonymizer.anonymize(group, session);
                    JSONArray row = new JSONArray();
                    groupWriter.writeArray(group, row, fields);
                    jGroupRows.put((Object)row);
                }
            } else {
                for (Group group : groups) {
                    JSONArray row = new JSONArray();
                    groupWriter.writeArray(group, row, fields);
                    jGroupRows.put((Object)row);
                }
            }
            result.setResultObject(jGroupRows, "json");
        } else {
            Collection groups = (Collection)resultObject;
            JSONArray jGroups = new JSONArray(groups.size());
            GroupWriter groupWriter = new GroupWriter();
            if (Anonymizers.isGuest(session)) {
                AnonymizerService<Group> anonymizer = Anonymizers.optAnonymizerFor(Module.GROUP);
                for (Group group : groups) {
                    group = anonymizer.anonymize(group, session);
                    JSONObject jGroup = new JSONObject(6);
                    groupWriter.writeGroup(group, jGroup);
                    jGroups.put((Object)jGroup);
                }
            } else {
                for (Group group : groups) {
                    JSONObject jGroup = new JSONObject(6);
                    groupWriter.writeGroup(group, jGroup);
                    jGroups.put((Object)jGroup);
                }
            }
            result.setResultObject(jGroups, "json");
        }
    }
}

