/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.internal;

import com.openexchange.exception.OXException;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.internal.RdbGroupStorage;
import com.openexchange.group.internal.VirtualGroupStorage;
import com.openexchange.server.Initialization;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupInit
implements Initialization {
    private static final Logger LOG = LoggerFactory.getLogger(GroupInit.class);
    private static final GroupInit SINGLETON = new GroupInit();
    private static final AtomicBoolean initialized = new AtomicBoolean();

    public void start() throws OXException {
        if (initialized.get()) {
            LOG.debug("GroupStorage duplicate initialization.");
        }
        GroupStorage.setInstance(new VirtualGroupStorage(new RdbGroupStorage()));
        initialized.set(true);
    }

    public void stop() throws OXException {
        if (!initialized.get()) {
            LOG.debug("GroupStorage duplicate shutdown.");
        }
        GroupStorage.setInstance(null);
        initialized.set(false);
    }

    public static GroupInit getInstance() {
        return SINGLETON;
    }
}

