/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.tx;

import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.AfterReadAwareFolderStorage;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.database.DatabaseFolderStorage;
import com.openexchange.folderstorage.database.DatabaseFolderType;
import com.openexchange.folderstorage.osgi.FolderStorageServices;
import com.openexchange.folderstorage.tx.ResilientConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashSet;

public class TransactionManager {
    public static final String PARAMETER_KEY = TransactionManager.class.getName();
    private final Collection<FolderStorage> openedStorages = new LinkedHashSet<FolderStorage>(6);
    private final StorageParameters storageParameters;
    private DatabaseService dbService;
    private Connection connection = null;
    private boolean ownsConnection;
    private int initCount = 0;

    public static TransactionManager initTransaction(StorageParameters storageParameters) throws OXException {
        TransactionManager transactionManager = TransactionManager.getTransactionManager(storageParameters);
        if (transactionManager == null) {
            transactionManager = new TransactionManager(storageParameters);
            storageParameters.putParameter(FolderType.GLOBAL, PARAMETER_KEY, transactionManager);
        }
        ++transactionManager.initCount;
        return transactionManager;
    }

    public static boolean isManagedTransaction(StorageParameters storageParameters) {
        return TransactionManager.getTransactionManager(storageParameters) != null;
    }

    public static TransactionManager getTransactionManager(StorageParameters storageParameters) {
        return (TransactionManager)storageParameters.getParameter(FolderType.GLOBAL, PARAMETER_KEY);
    }

    private TransactionManager(StorageParameters storageParameters) throws OXException {
        this.storageParameters = storageParameters;
        DatabaseFolderStorage.ConnectionMode connectionMode = (DatabaseFolderStorage.ConnectionMode)storageParameters.getParameter(DatabaseFolderType.getInstance(), "DB.Con");
        if (connectionMode == null && !this.initConnectionViaDecorator()) {
            this.dbService = FolderStorageServices.requireService(DatabaseService.class);
            this.connection = this.dbService.getWritable(storageParameters.getContext());
            connectionMode = new DatabaseFolderStorage.ConnectionMode(new ResilientConnection(this.connection), AfterReadAwareFolderStorage.Mode.WRITE);
            storageParameters.putParameter(DatabaseFolderType.getInstance(), "DB.Con", connectionMode);
            this.ownsConnection = true;
            try {
                Databases.startTransaction((Connection)this.connection);
            }
            catch (SQLException e) {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e.getMessage());
            }
        }
    }

    private boolean initConnectionViaDecorator() throws OXException {
        FolderServiceDecorator decorator = this.storageParameters.getDecorator();
        if (decorator != null) {
            Object connectionProperty = decorator.getProperty(Connection.class.getName());
            try {
                if (connectionProperty != null && connectionProperty instanceof Connection && !((Connection)connectionProperty).isReadOnly()) {
                    this.connection = (Connection)connectionProperty;
                    DatabaseFolderStorage.ConnectionMode connectionMode = new DatabaseFolderStorage.ConnectionMode(new ResilientConnection((Connection)connectionProperty), AfterReadAwareFolderStorage.Mode.WRITE);
                    this.storageParameters.putParameter(DatabaseFolderType.getInstance(), "DB.Con", connectionMode);
                    this.ownsConnection = false;
                    return true;
                }
            }
            catch (SQLException e) {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e.getMessage());
            }
        }
        return false;
    }

    public void transactionStarted(FolderStorage storage) {
        this.openedStorages.add(storage);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void rollback() {
        if (--this.initCount <= 0) {
            if (this.ownsConnection && this.connection != null) {
                Databases.rollback((Connection)this.connection);
                Databases.autocommit((Connection)this.connection);
                this.dbService.backWritable(this.storageParameters.getContext(), this.connection);
            }
            for (FolderStorage fs : this.openedStorages) {
                fs.rollback(this.storageParameters);
            }
        }
    }

    public void commit() throws OXException {
        if (--this.initCount == 0) {
            if (this.ownsConnection && this.connection != null) {
                try {
                    this.connection.commit();
                }
                catch (SQLException e) {
                    throw FolderExceptionErrorMessage.SQL_ERROR.create(e.getMessage());
                }
                Databases.autocommit((Connection)this.connection);
                this.dbService.backWritable(this.storageParameters.getContext(), this.connection);
            }
            for (FolderStorage fs : this.openedStorages) {
                fs.commitTransaction(this.storageParameters);
            }
        }
    }
}

