/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook.sql;

import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.internal.Tools;
import com.openexchange.folderstorage.outlook.sql.Utility;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Delete {
    private static final Logger LOGGER = LoggerFactory.getLogger(Delete.class);

    private Delete() {
    }

    public static void hardDeleteFolder(int cid, int tree, int user, String folderId, boolean global, boolean recursive) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getWritable(cid);
        boolean rollback = false;
        try {
            con.setAutoCommit(false);
            rollback = true;
            Delete.hardDeleteFolder(cid, tree, user, folderId, global, recursive, con);
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            databaseService.backWritable(cid, con);
        }
    }

    public static void hardDeleteFolder(int cid, int tree, int user, String folderId, boolean global, boolean recursive, Connection con) throws OXException {
        if (null == con) {
            Delete.hardDeleteFolder(cid, tree, user, folderId, global, recursive);
            return;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int pos;
            if (recursive) {
                stmt = con.prepareStatement(global ? "SELECT folderId FROM virtualTree WHERE cid = ? AND tree = ? AND parentId = ?" : "SELECT folderId FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?");
                pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, tree);
                if (!global) {
                    stmt.setInt(pos++, user);
                }
                stmt.setString(pos, folderId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    LinkedList<String> children = new LinkedList<String>();
                    do {
                        children.add(rs.getString(1));
                    } while (rs.next());
                    Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                    for (String childId : children) {
                        boolean nextGlobal = global && Tools.getUnsignedInteger(childId) > 0;
                        Delete.hardDeleteFolder(cid, tree, user, childId, nextGlobal, true, con);
                    }
                } else {
                    Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                }
            }
            stmt = con.prepareStatement(global ? "DELETE FROM virtualSubscription WHERE cid = ? AND tree = ? AND folderId = ?" : "DELETE FROM virtualSubscription WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            if (!global) {
                stmt.setInt(pos++, user);
            }
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
            Databases.closeSQLStuff((Statement)stmt);
            stmt = con.prepareStatement(global ? "DELETE FROM virtualPermission WHERE cid = ? AND tree = ? AND folderId = ?" : "DELETE FROM virtualPermission WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            if (!global) {
                stmt.setInt(pos++, user);
            }
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
            Databases.closeSQLStuff((Statement)stmt);
            stmt = con.prepareStatement(global ? "DELETE FROM virtualTree WHERE cid = ? AND tree = ? AND folderId = ?" : "DELETE FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            if (!global) {
                stmt.setInt(pos++, user);
            }
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
            Databases.closeSQLStuff((Statement)stmt);
        }
        catch (SQLException e) {
            try {
                Utility.debugSQL(stmt);
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
    }

    public static boolean deleteFolder(int cid, int tree, int user, String folderId, boolean global, boolean backup) throws OXException {
        DatabaseService databaseService = Utility.getDatabaseService();
        Connection con = databaseService.getWritable(cid);
        try {
            con.setAutoCommit(false);
            boolean ret = Delete.deleteFolder(cid, tree, user, folderId, global, backup, con);
            con.commit();
            boolean bl = ret;
            return bl;
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            databaseService.backWritable(cid, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteFolder(int cid, int tree, int user, String folderId, boolean global, boolean backup, Connection con) throws OXException {
        boolean success;
        int pos;
        if (null == con) {
            return Delete.deleteFolder(cid, tree, user, folderId, global, backup);
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(global ? "SELECT folderId FROM virtualTree WHERE cid = ? AND tree = ? AND parentId = ?" : "SELECT folderId FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND parentId = ?");
            int pos2 = 1;
            stmt.setInt(pos2++, cid);
            stmt.setInt(pos2++, tree);
            if (!global) {
                stmt.setInt(pos2++, user);
            }
            stmt.setString(pos2, folderId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                LinkedList<String> children = new LinkedList<String>();
                do {
                    children.add(rs.getString(1));
                } while (rs.next());
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                rs = null;
                stmt = null;
                for (String childId : children) {
                    boolean nextGlobal = Tools.getUnsignedInteger(childId) > 0;
                    Delete.deleteFolder(cid, tree, user, childId, nextGlobal, backup, con);
                }
            }
        }
        catch (SQLException e) {
            try {
                Utility.debugSQL(stmt);
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        stmt = null;
        if (backup) {
            try {
                stmt = con.prepareStatement(global ? "INSERT INTO virtualBackupTree (cid, tree, user, folderId, parentId, lastModified, modifiedBy, shadow, sortNum) SELECT virtualTree.cid, virtualTree.tree, virtualTree.user, virtualTree.folderId, virtualTree.parentId, virtualTree.lastModified, virtualTree.modifiedBy, virtualTree.shadow, virtualTree.sortNum FROM virtualTree WHERE virtualTree.cid = ? AND virtualTree.tree = ? AND virtualTree.folderId = ?" : "INSERT INTO virtualBackupTree (cid, tree, user, folderId, parentId, lastModified, modifiedBy, shadow, sortNum) SELECT virtualTree.cid, virtualTree.tree, virtualTree.user, virtualTree.folderId, virtualTree.parentId, virtualTree.lastModified, virtualTree.modifiedBy, virtualTree.shadow, virtualTree.sortNum FROM virtualTree WHERE virtualTree.cid = ? AND virtualTree.tree = ? AND virtualTree.user = ? AND virtualTree.folderId = ?");
                int pos3 = 1;
                stmt.setInt(pos3++, cid);
                stmt.setInt(pos3++, tree);
                if (!global) {
                    stmt.setInt(pos3++, user);
                }
                stmt.setString(pos3, folderId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                Utility.debugSQL(stmt);
                Logger log = LoggerFactory.getLogger(Delete.class);
                log.debug("Backup failed.", (Throwable)e);
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
            try {
                stmt = con.prepareStatement(global ? "INSERT INTO virtualBackupPermission SELECT * FROM virtualPermission WHERE cid = ? AND tree = ? AND folderId = ?" : "INSERT INTO virtualBackupPermission SELECT * FROM virtualPermission WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
                int pos4 = 1;
                stmt.setInt(pos4++, cid);
                stmt.setInt(pos4++, tree);
                if (!global) {
                    stmt.setInt(pos4++, user);
                }
                stmt.setString(pos4, folderId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                Utility.debugSQL(stmt);
                Logger log = LoggerFactory.getLogger(Delete.class);
                log.debug("Backup failed.", (Throwable)e);
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
            try {
                stmt = con.prepareStatement(global ? "INSERT INTO virtualBackupSubscription SELECT * FROM virtualSubscription WHERE cid = ? AND tree = ? AND folderId = ?" : "INSERT INTO virtualBackupSubscription SELECT * FROM virtualSubscription WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
                int pos5 = 1;
                stmt.setInt(pos5++, cid);
                stmt.setInt(pos5++, tree);
                if (!global) {
                    stmt.setInt(pos5++, user);
                }
                stmt.setString(pos5, folderId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                Utility.debugSQL(stmt);
                Logger log = LoggerFactory.getLogger(Delete.class);
                log.debug("Backup failed.", (Throwable)e);
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
        }
        try {
            stmt = con.prepareStatement(global ? "DELETE FROM virtualSubscription WHERE cid = ? AND tree = ? AND folderId = ?" : "DELETE FROM virtualSubscription WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            if (!global) {
                stmt.setInt(pos++, user);
            }
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            Utility.debugSQL(stmt);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        try {
            stmt = con.prepareStatement(global ? "DELETE FROM virtualPermission WHERE cid = ? AND tree = ? AND folderId = ?" : "DELETE FROM virtualPermission WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            if (!global) {
                stmt.setInt(pos++, user);
            }
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            Utility.debugSQL(stmt);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        try {
            stmt = con.prepareStatement(global ? "DELETE FROM virtualTree WHERE cid = ? AND tree = ? AND folderId = ?" : "DELETE FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
            int pos6 = 1;
            stmt.setInt(pos6++, cid);
            stmt.setInt(pos6++, tree);
            if (!global) {
                stmt.setInt(pos6++, user);
            }
            stmt.setString(pos6, folderId);
            success = stmt.executeUpdate() > 0;
        }
        catch (SQLException e) {
            Utility.debugSQL(stmt);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        if (success) {
            LOGGER.debug("{} {}folder {} from virtual tree {} (user={}, context={})", new Object[]{backup ? "Backup'ed" : "Deleted", global ? "global " : "", folderId, tree, user, cid, new Throwable("Debug throwable")});
        }
        return success;
    }
}

