/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.folderstorage.FolderEventConstants;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.outlook.OutlookFolderStorage;
import com.openexchange.folderstorage.outlook.memory.MemoryTable;
import com.openexchange.folderstorage.outlook.osgi.OutlookFolderStorageServiceTracker;
import com.openexchange.folderstorage.outlook.osgi.Services;
import com.openexchange.folderstorage.outlook.sql.Update;
import com.openexchange.mailaccount.MailAccountDeleteListener;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.messaging.registry.MessagingServiceRegistry;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.push.PushEventConstants;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.threadpool.ThreadPoolService;
import java.sql.Connection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlookFolderStorageActivator
extends HousekeepingActivator {
    protected Class<?>[] getNeededServices() {
        return new Class[]{DatabaseService.class, MailAccountStorageService.class, ThreadPoolService.class, MessagingServiceRegistry.class, UnifiedInboxManagement.class, ConfigurationService.class, FileStorageServiceRegistry.class, SessiondService.class, EventAdmin.class};
    }

    protected void startBundle() throws Exception {
        final Logger logger = LoggerFactory.getLogger(OutlookFolderStorageActivator.class);
        try {
            Services.setServiceLookup((ServiceLookup)this);
            this.rememberTracker(new ServiceTracker(this.context, FolderStorage.class, (ServiceTrackerCustomizer)new OutlookFolderStorageServiceTracker(this.context)));
            this.openTrackers();
            this.registerService(MailAccountDeleteListener.class, new MailAccountDeleteListener(){

                @Override
                public void onBeforeMailAccountDeletion(int id, Map<String, Object> eventProps, int user, int cid, Connection con) throws OXException {
                    OutlookFolderStorage.clearTCM();
                }

                @Override
                public void onAfterMailAccountDeletion(int id, Map<String, Object> eventProps, int user, int cid, Connection con) throws OXException {
                }
            }, null);
            Hashtable<String, String> dictionary = new Hashtable<String, String>(2);
            ((Dictionary)dictionary).put("tree", "1");
            this.registerService(FolderStorage.class, OutlookFolderStorage.getInstance(), dictionary);
            EventHandler pushMailEventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    OutlookFolderStorage.clearTCM();
                }
            };
            Hashtable<String, Object> dict = new Hashtable<String, Object>(1);
            ((Dictionary)dict).put("event.topics", PushEventConstants.getAllTopics());
            this.registerService(EventHandler.class, pushMailEventHandler, dict);
            EventHandler folderEventHandler = new EventHandler(){
                private final int tree = Integer.parseInt("1");

                public void handleEvent(Event event) {
                    OutlookFolderStorage.clearTCM();
                    if ("com/openexchange/folderstorage/identifiers".equals(event.getTopic())) {
                        Session session = (Session)event.getProperty("com.openexchange.folderstorage.session");
                        String newId = (String)event.getProperty("com.openexchange.folderstorage.newIdentifier");
                        String oldId = (String)event.getProperty("com.openexchange.folderstorage.oldIdentifier");
                        String delim = (String)event.getProperty("com.openexchange.folderstorage.delimiter");
                        try {
                            Update.updateIds(session.getContextId(), this.tree, session.getUserId(), newId, oldId, delim);
                        }
                        catch (Exception e) {
                            logger.error("", (Throwable)e);
                        }
                        MemoryTable memoryTable = MemoryTable.optMemoryTableFor(session);
                        if (null != memoryTable) {
                            try {
                                memoryTable.initializeTree(this.tree, session.getUserId(), session.getContextId());
                            }
                            catch (Exception e) {
                                logger.error("", (Throwable)e);
                            }
                        }
                    }
                }
            };
            dict = new Hashtable(1);
            ((Dictionary)dict).put("event.topics", FolderEventConstants.getAllTopics());
            this.registerService(EventHandler.class.getName(), folderEventHandler, dict);
            EventHandler sessionEventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    Integer userId;
                    Integer contextId;
                    String topic = event.getTopic();
                    if ("com/openexchange/sessiond/remove/last".equals(topic) && null != (contextId = (Integer)event.getProperty("com.openexchange.sessiond.contextId")) && null != (userId = (Integer)event.getProperty("com.openexchange.sessiond.userId"))) {
                        MemoryTable.dropMemoryTableFrom(userId, contextId);
                    }
                }
            };
            dict = new Hashtable(1);
            ((Dictionary)dict).put("event.topics", "com/openexchange/sessiond/remove/last");
            this.registerService(EventHandler.class.getName(), sessionEventHandler, dict);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw e;
        }
    }

    protected void stopBundle() throws Exception {
        super.stopBundle();
        Services.setServiceLookup(null);
    }
}

