/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook;

import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.StoragePriority;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutlookFolderStorageRegistry
implements FolderStorageDiscoverer {
    private static final OutlookFolderStorageRegistry instance = new OutlookFolderStorageRegistry();
    private final ConcurrentMap<String, Queue<FolderStorage>> registry = new ConcurrentHashMap<String, Queue<FolderStorage>>();
    private final Queue<FolderStorage> genStorages = new ConcurrentLinkedQueue<FolderStorage>();
    private final ConcurrentMap<ContentType, FolderStorage> contentTypes = new ConcurrentHashMap<ContentType, FolderStorage>();

    public static OutlookFolderStorageRegistry getInstance() {
        return instance;
    }

    private OutlookFolderStorageRegistry() {
    }

    public boolean addFolderStorage(String treeId, FolderStorage folderStorage) {
        if (!(FolderStorage.ALL_TREE_ID.equals(treeId) && StoragePriority.HIGHEST.equals(folderStorage.getStoragePriority()) || FolderStorage.REAL_TREE_ID.equals(treeId))) {
            return false;
        }
        ContentType[] contentTypes = folderStorage.getSupportedContentTypes();
        if (null != contentTypes && contentTypes.length > 0) {
            boolean success = true;
            HashSet<ContentType> added = new HashSet<ContentType>(contentTypes.length);
            for (int j = 0; success && j < contentTypes.length; ++j) {
                if (null == this.contentTypes.putIfAbsent(contentTypes[j], folderStorage)) {
                    added.add(contentTypes[j]);
                    continue;
                }
                Logger log = LoggerFactory.getLogger(OutlookFolderStorageRegistry.class);
                log.error("Duplicate folder storage for content type \"{}\"", (Object)contentTypes[j].toString(), (Object)new Throwable());
                success = false;
            }
            if (!success) {
                for (ContentType contentType : added) {
                    this.contentTypes.remove(contentType);
                }
                return false;
            }
        }
        if (FolderStorage.ALL_TREE_ID.equals(treeId)) {
            this.genStorages.add(folderStorage);
        } else {
            ConcurrentLinkedQueue<FolderStorage> tmp;
            ConcurrentLinkedQueue<FolderStorage> storages = (ConcurrentLinkedQueue<FolderStorage>)this.registry.get(treeId);
            if (null == storages && null == (storages = (Queue)this.registry.putIfAbsent(treeId, tmp = new ConcurrentLinkedQueue<FolderStorage>()))) {
                storages = tmp;
            }
            storages.add(folderStorage);
        }
        return true;
    }

    @Override
    public FolderStorage getFolderStorage(String treeId, String folderId) {
        Queue storages;
        if (!this.genStorages.isEmpty()) {
            for (FolderStorage folderStorage : this.genStorages) {
                if (!folderStorage.getFolderType().servesTreeId(treeId)) continue;
                return folderStorage;
            }
        }
        if (null == (storages = (Queue)this.registry.get(treeId))) {
            return null;
        }
        for (FolderStorage folderStorage : storages) {
            if (!folderStorage.getFolderType().servesFolderId(folderId)) continue;
            return folderStorage;
        }
        return null;
    }

    public FolderStorage getDedicatedFolderStorage(String treeId, String folderId) {
        Queue storages = (Queue)this.registry.get(treeId);
        if (null == storages) {
            return null;
        }
        for (FolderStorage folderStorage : storages) {
            if (!folderStorage.getFolderType().servesFolderId(folderId)) continue;
            return folderStorage;
        }
        return null;
    }

    @Override
    public FolderStorage[] getFolderStoragesForParent(String treeId, String parentId) {
        Queue storages;
        if (!this.genStorages.isEmpty()) {
            for (FolderStorage folderStorage : this.genStorages) {
                FolderType folderType = folderStorage.getFolderType();
                if (!folderType.servesTreeId(treeId) || !folderType.servesParentId(parentId)) continue;
                return new FolderStorage[]{folderStorage};
            }
        }
        if (null == (storages = (Queue)this.registry.get(treeId))) {
            return new FolderStorage[0];
        }
        ArrayList<FolderStorage> l = new ArrayList<FolderStorage>(4);
        for (FolderStorage folderStorage : storages) {
            if (!folderStorage.getFolderType().servesParentId(parentId)) continue;
            l.add(folderStorage);
        }
        return l.toArray(new FolderStorage[l.size()]);
    }

    @Override
    public FolderStorage[] getFolderStoragesForTreeID(String treeId) {
        Queue storages;
        if (!this.genStorages.isEmpty()) {
            for (FolderStorage folderStorage : this.genStorages) {
                FolderType folderType = folderStorage.getFolderType();
                if (!folderType.servesTreeId(treeId)) continue;
                return new FolderStorage[]{folderStorage};
            }
        }
        if (null == (storages = (Queue)this.registry.get(treeId))) {
            return new FolderStorage[0];
        }
        return storages.toArray(new FolderStorage[storages.size()]);
    }

    @Override
    public FolderStorage[] getTreeFolderStorages(String treeId) {
        Queue storages;
        if (!this.genStorages.isEmpty()) {
            for (FolderStorage folderStorage : this.genStorages) {
                if (StoragePriority.HIGHEST.equals(folderStorage.getStoragePriority()) || !folderStorage.getFolderType().servesTreeId(treeId)) continue;
                return new FolderStorage[]{folderStorage};
            }
        }
        if (null == (storages = (Queue)this.registry.get(treeId))) {
            return new FolderStorage[0];
        }
        return storages.toArray(new FolderStorage[storages.size()]);
    }

    @Override
    public FolderStorage getFolderStorageByContentType(String treeId, ContentType contentType) {
        FolderStorage folderStorage = (FolderStorage)this.contentTypes.get(contentType);
        if (null == folderStorage) {
            return null;
        }
        if (folderStorage.getFolderType().servesTreeId(treeId)) {
            return folderStorage;
        }
        return null;
    }

    public void removeFolderStorage(String treeId, FolderStorage folderStorage) {
        if (!(FolderStorage.ALL_TREE_ID.equals(treeId) && StoragePriority.HIGHEST.equals(folderStorage.getStoragePriority()) || FolderStorage.REAL_TREE_ID.equals(treeId))) {
            return;
        }
        if (FolderStorage.ALL_TREE_ID.equals(treeId)) {
            this.genStorages.remove(folderStorage);
        } else {
            Queue storages = (Queue)this.registry.get(treeId);
            if (null == storages) {
                return;
            }
            storages.remove(folderStorage);
        }
        ContentType[] contentTypes = folderStorage.getSupportedContentTypes();
        if (null != contentTypes && contentTypes.length > 0) {
            for (ContentType contentType : contentTypes) {
                this.contentTypes.remove(contentType);
            }
        }
    }
}

