/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.messaging.osgi;

import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.mail.contentType.MailContentType;
import com.openexchange.folderstorage.messaging.MessagingFolderStorage;
import com.openexchange.folderstorage.messaging.osgi.Services;
import com.openexchange.messaging.registry.MessagingServiceRegistry;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.server.ServiceLookup;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.LoggerFactory;

public final class MessagingFolderStorageActivator
extends HousekeepingActivator {
    protected Class<?>[] getNeededServices() {
        return new Class[]{MessagingServiceRegistry.class};
    }

    protected void startBundle() throws Exception {
        try {
            Services.setServiceLookup((ServiceLookup)this);
            this.rememberTracker(new ServiceTracker(this.context, FolderStorage.class, (ServiceTrackerCustomizer)new Switcher(this.context)));
            this.openTrackers();
            Hashtable<String, String> dictionary = new Hashtable<String, String>(2);
            ((Dictionary)dictionary).put("tree", FolderStorage.REAL_TREE_ID);
            this.registerService(FolderStorage.class, new MessagingFolderStorage((ServiceLookup)this), dictionary);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(MessagingFolderStorageActivator.class).error("", (Throwable)e);
            throw e;
        }
    }

    protected void stopBundle() throws Exception {
        Services.setServiceLookup(null);
        super.stopBundle();
    }

    private static final class Switcher
    implements ServiceTrackerCustomizer<FolderStorage, FolderStorage> {
        private final BundleContext context;

        Switcher(BundleContext context) {
            this.context = context;
        }

        public FolderStorage addingService(ServiceReference<FolderStorage> reference) {
            FolderStorage folderStorage = (FolderStorage)this.context.getService(reference);
            if (Arrays.asList(folderStorage.getSupportedContentTypes()).contains(MailContentType.getInstance())) {
                MessagingFolderStorage.setMailFolderStorageAvailable(true);
                return folderStorage;
            }
            this.context.ungetService(reference);
            return null;
        }

        public void modifiedService(ServiceReference<FolderStorage> reference, FolderStorage service) {
        }

        public void removedService(ServiceReference<FolderStorage> reference, FolderStorage service) {
            if (null != service) {
                FolderStorage folderStorage = service;
                if (Arrays.asList(folderStorage.getSupportedContentTypes()).contains(MailContentType.getInstance())) {
                    MessagingFolderStorage.setMailFolderStorageAvailable(false);
                }
                this.context.ungetService(reference);
            }
        }
    }
}

