/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.mail;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.AbstractFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.mail.MailFolderImpl;
import com.openexchange.folderstorage.mail.MailPermissionImpl;
import com.openexchange.folderstorage.type.MailType;
import com.openexchange.folderstorage.type.SystemType;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.tools.session.ServerSession;

public class ExternalMailAccountRootFolder
extends AbstractFolder {
    private static final long serialVersionUID = -7259106085690350497L;
    protected final MailFolderImpl.MailFolderType mailFolderType;
    protected final int userId;
    protected final int contexctId;
    private static final int[] mapping = new int[]{0, -1, 1, -1, 2, -1, -1, -1, 4};
    private static final int MAX_PERMISSION = 64;

    public ExternalMailAccountRootFolder(MailAccount mailAccount, MailConfig mailConfig, ServerSession session) throws OXException {
        this.userId = session.getUserId();
        this.contexctId = session.getContextId();
        String fullname = "default";
        this.accountId = this.id = MailFolderUtility.prepareFullname(mailAccount.getId(), "default");
        this.name = UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX.equals(mailAccount.getMailProtocol()) ? StringHelper.valueOf(session.getUser().getLocale()).getString(MailStrings.UNIFIED_MAIL) : mailAccount.getName();
        this.parent = FolderStorage.PRIVATE_ID;
        MailPermissionImpl mp = new MailPermissionImpl();
        mp.setEntity(this.userId);
        mp.setAllPermissions(8, 0, 0, 0);
        mp.setAdmin(false);
        this.permissions = new Permission[]{mp};
        this.type = SystemType.getInstance();
        this.subscribed = true;
        this.subscribedSubfolders = true;
        this.capabilities = mailConfig.getCapabilities().getCapabilities();
        this.summary = "";
        this.deefault = false;
        this.total = 0;
        this.nu = 0;
        this.unread = 0;
        this.deleted = 0;
        this.mailFolderType = MailFolderImpl.MailFolderType.ROOT;
        this.bits = ExternalMailAccountRootFolder.createPermissionBits(mp.getFolderPermission(), mp.getReadPermission(), mp.getWritePermission(), mp.getDeletePermission(), mp.isAdmin());
    }

    static int createPermissionBits(int fp, int orp, int owp, int odp, boolean adminFlag) throws OXException {
        int[] perms = new int[]{fp == 64 ? 128 : fp, orp == 64 ? 128 : orp, owp == 64 ? 128 : owp, odp == 64 ? 128 : odp, adminFlag ? 1 : 0};
        return ExternalMailAccountRootFolder.createPermissionBits(perms);
    }

    private static int createPermissionBits(int[] permission) throws OXException {
        int retval = 0;
        boolean first = true;
        for (int i = permission.length - 1; i >= 0; --i) {
            int shiftVal = i * 7;
            if (first) {
                retval += permission[i] << shiftVal;
                first = false;
                continue;
            }
            if (permission[i] == 128) {
                retval += 64 << shiftVal;
                continue;
            }
            try {
                retval += mapping[permission[i]] << shiftVal;
                continue;
            }
            catch (Exception e) {
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
        return retval;
    }

    @Override
    public ExternalMailAccountRootFolder clone() {
        return (ExternalMailAccountRootFolder)super.clone();
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public ContentType getContentType() {
        return this.mailFolderType.getContentType();
    }

    @Override
    public int getDefaultType() {
        return this.mailFolderType.getType();
    }

    @Override
    public void setDefaultType(int defaultType) {
    }

    @Override
    public Type getType() {
        return MailType.getInstance();
    }

    @Override
    public void setContentType(ContentType contentType) {
    }

    @Override
    public void setType(Type type) {
    }

    @Override
    public boolean isGlobalID() {
        return false;
    }
}

