/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.performers.AbstractUserizedFolderPerformer;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.List;

public final class PathPerformer
extends AbstractUserizedFolderPerformer {
    public PathPerformer(ServerSession session, FolderServiceDecorator decorator) throws OXException {
        super(session, decorator);
    }

    public PathPerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context, decorator);
    }

    public PathPerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        super(session, decorator, folderStorageDiscoverer);
    }

    public PathPerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, decorator, folderStorageDiscoverer);
    }

    public UserizedFolder[] doPath(String treeId, String folderId, boolean all) throws OXException {
        UserizedFolder[] ret;
        if (FolderStorage.ROOT_ID.equals(folderId)) {
            return new UserizedFolder[0];
        }
        FolderStorage folderStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, folderId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(4);
        if (folderStorage.startTransaction(this.storageParameters, false)) {
            openedStorages.add(folderStorage);
        }
        try {
            Folder folder = folderStorage.getFolder(treeId, folderId, this.storageParameters);
            PermissionProvider permissionProvider = null == this.session ? new UserCtxPermissionProvider(this.user, this.context, this.getAllowedContentTypes()) : new SessionPermissionProvider(this.session, this.getAllowedContentTypes());
            Permission ownPermission = permissionProvider.getOwnPermission(folder);
            if (!ownPermission.isVisible()) {
                throw FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.create(this.getFolderInfo4Error(folder), this.getUserInfo4Error(), this.getContextInfo4Error());
            }
            ArrayList<UserizedFolder> path = new ArrayList<UserizedFolder>(8);
            UserizedFolder userizedFolder = this.getUserizedFolder(folder, ownPermission, treeId, all, true, this.storageParameters, openedStorages);
            path.add(userizedFolder);
            while (!FolderStorage.ROOT_ID.equals(userizedFolder.getParentID()) && null != userizedFolder.getParentID()) {
                FolderStorage fs = this.getOpenedStorage(userizedFolder.getParentID(), treeId, this.storageParameters, openedStorages);
                folder = fs.getFolder(treeId, userizedFolder.getParentID(), this.storageParameters);
                ownPermission = permissionProvider.getOwnPermission(folder);
                if (!ownPermission.isVisible()) {
                    throw FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.create(this.getFolderInfo4Error(folder), this.getUserInfo4Error(), this.getContextInfo4Error());
                }
                userizedFolder = this.getUserizedFolder(folder, ownPermission, treeId, all, true, this.storageParameters, openedStorages);
                path.add(userizedFolder);
            }
            ret = path.toArray(new UserizedFolder[path.size()]);
            for (FolderStorage fs : openedStorages) {
                fs.commitTransaction(this.storageParameters);
            }
        }
        catch (OXException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        return ret;
    }

    public String[] doForcePath(String treeId, String folderId, boolean all) throws OXException {
        String[] ret;
        if (FolderStorage.ROOT_ID.equals(folderId)) {
            return new String[0];
        }
        FolderStorage folderStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, folderId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(4);
        if (folderStorage.startTransaction(this.storageParameters, false)) {
            openedStorages.add(folderStorage);
        }
        try {
            Folder folder = folderStorage.getFolder(treeId, folderId, this.storageParameters);
            ArrayList<String> path = new ArrayList<String>(8);
            path.add(folderId);
            while (!FolderStorage.ROOT_ID.equals(folder.getParentID())) {
                FolderStorage fs = this.getOpenedStorage(folder.getParentID(), treeId, this.storageParameters, openedStorages);
                folder = fs.getFolder(treeId, folder.getParentID(), this.storageParameters);
                path.add(folder.getID());
            }
            ret = path.toArray(new String[path.size()]);
            for (FolderStorage fs : openedStorages) {
                fs.commitTransaction(this.storageParameters);
            }
        }
        catch (OXException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        return ret;
    }

    private static final class UserCtxPermissionProvider
    implements PermissionProvider {
        private final User user;
        private final Context ctx;
        private final List<ContentType> allowedContentTypes;

        public UserCtxPermissionProvider(User user, Context ctx, List<ContentType> allowedContentTypes) {
            this.user = user;
            this.ctx = ctx;
            this.allowedContentTypes = allowedContentTypes;
        }

        @Override
        public Permission getOwnPermission(Folder folder) throws OXException {
            return CalculatePermission.calculate(folder, this.user, this.ctx, this.allowedContentTypes);
        }
    }

    private static final class SessionPermissionProvider
    implements PermissionProvider {
        private final ServerSession session;
        private final List<ContentType> allowedContentTypes;

        public SessionPermissionProvider(ServerSession session, List<ContentType> allowedContentTypes) {
            this.session = session;
            this.allowedContentTypes = allowedContentTypes;
        }

        @Override
        public Permission getOwnPermission(Folder folder) {
            return CalculatePermission.calculate(folder, this.session, this.allowedContentTypes);
        }
    }

    private static interface PermissionProvider {
        public Permission getOwnPermission(Folder var1) throws OXException;
    }
}

