/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.performers.AbstractUserizedFolderPerformer;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GetPerformer
extends AbstractUserizedFolderPerformer {
    private static final Logger LOG = LoggerFactory.getLogger(GetPerformer.class);

    public GetPerformer(ServerSession session, FolderServiceDecorator decorator) throws OXException {
        super(session, decorator);
    }

    public GetPerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context, decorator);
    }

    public GetPerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        super(session, decorator, folderStorageDiscoverer);
    }

    public GetPerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, decorator, folderStorageDiscoverer);
    }

    public UserizedFolder doGet(String treeId, String folderId) throws OXException {
        FolderStorage folderStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, folderId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(4);
        if (folderStorage.startTransaction(this.storageParameters, false)) {
            openedStorages.add(folderStorage);
        }
        try {
            Folder folder = folderStorage.getFolder(treeId, folderId, this.storageParameters);
            Permission ownPermission = null == this.getSession() ? CalculatePermission.calculate(folder, this.getUser(), this.getContext(), this.getAllowedContentTypes()) : CalculatePermission.calculate(folder, this.getSession(), this.getAllowedContentTypes());
            if (!ownPermission.isVisible()) {
                throw FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.create(this.getFolderInfo4Error(folder), this.getUserInfo4Error(), this.getContextInfo4Error());
            }
            UserizedFolder userizedFolder = this.getUserizedFolder(folder, ownPermission, treeId, true, true, this.storageParameters, openedStorages);
            for (FolderStorage fs : openedStorages) {
                fs.commitTransaction(this.storageParameters);
            }
            return userizedFolder;
        }
        catch (OXException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

