/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.GuestPermission;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.osgi.FolderStorageServices;
import com.openexchange.groupware.ComparedPermissions;
import com.openexchange.groupware.notify.hostname.HostData;
import com.openexchange.session.Session;
import com.openexchange.share.AuthenticationMode;
import com.openexchange.share.GuestInfo;
import com.openexchange.share.ShareService;
import com.openexchange.share.ShareTarget;
import com.openexchange.share.ShareTargetPath;
import com.openexchange.share.recipient.RecipientType;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ComparedFolderPermissions
extends ComparedPermissions<Permission, GuestPermission> {
    private final Session session;
    private ShareService shareService;
    private final Map<Integer, GuestInfo> guestInfos;
    private static final GuestInfo NO_GUEST = new GuestInfo(){

        public RecipientType getRecipientType() {
            return null;
        }

        public String getPassword() {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public int getGuestID() {
            return 0;
        }

        public String getEmailAddress() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public int getCreatedBy() {
            return 0;
        }

        public int getContextID() {
            return 0;
        }

        public String getBaseToken() {
            return null;
        }

        public AuthenticationMode getAuthentication() {
            return null;
        }

        public ShareTarget getLinkTarget() {
            return null;
        }

        public Date getExpiryDate() {
            return null;
        }

        public String generateLink(HostData hostData, ShareTargetPath targetPath) {
            return null;
        }
    };

    public ComparedFolderPermissions(Session session, Permission[] newPermissions, Permission[] originalPermissions) throws OXException {
        super((Object[])newPermissions, (Object[])originalPermissions);
        this.session = session;
        this.guestInfos = new HashMap<Integer, GuestInfo>();
        this.calc();
    }

    public ComparedFolderPermissions(Session session, Folder newFolder, Folder origFolder) throws OXException {
        this(session, newFolder.getPermissions(), origFolder.getPermissions());
    }

    private ShareService getShareService() throws OXException {
        ShareService shareService = this.shareService;
        if (null == shareService) {
            this.shareService = shareService = FolderStorageServices.requireService(ShareService.class);
        }
        return shareService;
    }

    protected boolean isSystemPermission(Permission p) {
        return p.getSystem() != 0;
    }

    protected boolean isUnresolvedGuestPermission(Permission p) {
        return p instanceof GuestPermission;
    }

    protected boolean isGroupPermission(Permission p) {
        return p.isGroup();
    }

    protected int getEntityId(Permission p) {
        return p.getEntity();
    }

    protected boolean areEqual(Permission p1, Permission p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        return p1.equals(p2);
    }

    protected boolean isGuestUser(int userId) throws OXException {
        return this.getGuestInfo(userId) != null;
    }

    public void rememberGuestInfo(GuestInfo guestInfo) {
        this.guestInfos.put(guestInfo.getGuestID(), guestInfo);
    }

    public GuestInfo getGuestInfo(int guestId) throws OXException {
        if (this.session == null) {
            return null;
        }
        GuestInfo guestInfo = this.guestInfos.get(guestId);
        if (guestInfo == null) {
            guestInfo = this.getShareService().getGuestInfo(this.session, guestId);
            if (guestInfo == null) {
                guestInfo = NO_GUEST;
            }
            this.guestInfos.put(guestId, guestInfo);
        }
        if (guestInfo == NO_GUEST) {
            return null;
        }
        return guestInfo;
    }
}

