/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Permissions;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.type.DocumentsType;
import com.openexchange.folderstorage.type.MusicType;
import com.openexchange.folderstorage.type.PicturesType;
import com.openexchange.folderstorage.type.TemplatesType;
import com.openexchange.folderstorage.type.TrashType;
import com.openexchange.folderstorage.type.VideosType;
import com.openexchange.framework.request.RequestContext;
import com.openexchange.framework.request.RequestContextHolder;
import com.openexchange.groupware.notify.hostname.HostData;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.impl.ConfigTree;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public final class Tools {
    private static final ConcurrentMap<String, Future<TimeZone>> TZ_MAP = new ConcurrentHashMap<String, Future<TimeZone>>();
    private static final int RADIX = 10;

    private Tools() {
    }

    public static TimeZone getTimeZone(final String timeZoneID) {
        FutureTask<TimeZone> ft;
        FutureTask<TimeZone> future = (FutureTask<TimeZone>)TZ_MAP.get(timeZoneID);
        if (null == future && null == (future = (Future)TZ_MAP.putIfAbsent(timeZoneID, ft = new FutureTask<TimeZone>(new Callable<TimeZone>(){

            @Override
            public TimeZone call() throws Exception {
                return TimeZone.getTimeZone(timeZoneID);
            }
        })))) {
            future = ft;
            ft.run();
        }
        try {
            return (TimeZone)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
        catch (CancellationException e) {
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                IllegalStateException ise = new IllegalStateException(e.getMessage());
                ise.initCause(e);
                throw ise;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IllegalStateException("Not unchecked", cause);
        }
    }

    public static boolean isGlobalId(String id) {
        return Tools.getUnsignedInteger(id) > 0;
    }

    public static int getUnsignedInteger(String s) {
        int digit;
        if (s == null) {
            return -1;
        }
        int max = s.length();
        if (max <= 0) {
            return -1;
        }
        if (s.charAt(0) == '-') {
            return -1;
        }
        int result = 0;
        int i = 0;
        int limit = -2147483647;
        int multmin = -214748364;
        if (i < max) {
            if ((digit = Tools.digit(s.charAt(i++))) < 0) {
                return -1;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = Tools.digit(s.charAt(i++))) < 0) {
                return -1;
            }
            if (result < -214748364) {
                return -1;
            }
            if ((result *= 10) < -2147483647 + digit) {
                return -1;
            }
            result -= digit;
        }
        return -result;
    }

    private static int digit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }

    @Deprecated
    public static int createPermissionBits(Permission perm) {
        return Tools.createPermissionBits(perm.getFolderPermission(), perm.getReadPermission(), perm.getWritePermission(), perm.getDeletePermission(), perm.isAdmin());
    }

    @Deprecated
    public static int createPermissionBits(int fp, int rp, int wp, int dp, boolean adminFlag) {
        return Permissions.createPermissionBits(fp, rp, wp, dp, adminFlag);
    }

    public static String getConfiguredDefaultFolder(ServerSession session, ContentType contentType, Type type) throws OXException {
        Setting setting;
        String settingsPath = Tools.getDefaultFolderSettingsPath(contentType, type);
        if (null != settingsPath && null != (setting = ConfigTree.getInstance().getSettingByPath(settingsPath))) {
            setting.getShared().getValue(session, session.getContext(), session.getUser(), session.getUserConfiguration(), setting);
            Object value = setting.getSingleValue();
            if (null != value && String.class.isInstance(value)) {
                return (String)value;
            }
        }
        return null;
    }

    private static String getDefaultFolderSettingsPath(ContentType contentType, Type type) {
        if (InfostoreContentType.class.isInstance(contentType)) {
            if (TrashType.getInstance().equals(type)) {
                return "modules/infostore/folder/trash";
            }
            if (DocumentsType.getInstance().equals(type)) {
                return "modules/infostore/folder/documents";
            }
            if (TemplatesType.getInstance().equals(type)) {
                return "modules/infostore/folder/templates";
            }
            if (VideosType.getInstance().equals(type)) {
                return "modules/infostore/folder/videos";
            }
            if (MusicType.getInstance().equals(type)) {
                return "modules/infostore/folder/music";
            }
            if (PicturesType.getInstance().equals(type)) {
                return "modules/infostore/folder/pictures";
            }
            return "folder/infostore";
        }
        return null;
    }

    public static HostData getHostData(Session session) {
        RequestContext requestContext = RequestContextHolder.get();
        if (requestContext == null && session != null) {
            return (HostData)session.getParameter("com.openexchange.groupware.hostdata");
        }
        return requestContext.getHostData();
    }
}

