/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.filestorage;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFileStorageFolder;
import com.openexchange.file.storage.DefaultFileStoragePermission;
import com.openexchange.file.storage.FileStorageAccounts;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStoragePermission;
import com.openexchange.file.storage.WarningsAware;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SetterAwareFolder;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StorageParametersUtility;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.filestorage.FileStorageFolderImpl;
import com.openexchange.folderstorage.filestorage.FileStorageFolderType;
import com.openexchange.folderstorage.filestorage.FileStorageId;
import com.openexchange.folderstorage.filestorage.contentType.FileStorageContentType;
import com.openexchange.folderstorage.tx.TransactionManager;
import com.openexchange.folderstorage.type.FileStorageType;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.Collators;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.sql.Connection;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.slf4j.LoggerFactory;

public final class FileStorageFolderStorage
implements FolderStorage {
    private static final String INFOSTORE_ACCOUNT_ID = "infostore";
    private static final String PARAM = "fs.folder.Access";
    private static final String PRIVATE_FOLDER_ID = String.valueOf(1);
    private static final String INFOSTORE = Integer.toString(9);
    private final ServiceLookup services;

    public FileStorageFolderStorage(ServiceLookup services) {
        this.services = services;
    }

    @Override
    public boolean startTransaction(StorageParameters parameters, boolean modify) throws OXException {
        if (null == parameters.getParameter(this.getFolderType(), PARAM)) {
            if (null == parameters.getSession()) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create();
            }
            IDBasedFolderAccessFactory factory = (IDBasedFolderAccessFactory)this.services.getService(IDBasedFolderAccessFactory.class);
            if (null == factory) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{IDBasedFolderAccessFactory.class.getName()});
            }
            IDBasedFolderAccess folderAccess = factory.createAccess(parameters.getSession());
            if (parameters.putParameterIfAbsent(this.getFolderType(), PARAM, folderAccess)) {
                if (!TransactionManager.isManagedTransaction(parameters)) {
                    return true;
                }
                TransactionManager transactionManager = TransactionManager.getTransactionManager(parameters);
                Session session = parameters.getSession();
                session.setParameter(Connection.class.getName() + '@' + Thread.currentThread().getId(), (Object)transactionManager.getConnection());
                transactionManager.transactionStarted(this);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(StorageParameters storageParameters) {
        IDBasedFolderAccess folderAccess = (IDBasedFolderAccess)storageParameters.getParameter(this.getFolderType(), PARAM);
        if (null != folderAccess) {
            try {
                folderAccess.rollback();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(FileStorageFolderStorage.class).warn("Unexpected error during rollback: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                Session session;
                if (null != storageParameters.putParameter(this.getFolderType(), PARAM, null) && null != (session = storageParameters.getSession()) && session.containsParameter(Connection.class.getName() + '@' + Thread.currentThread().getId())) {
                    session.setParameter(Connection.class.getName() + '@' + Thread.currentThread().getId(), null);
                }
            }
            FileStorageFolderStorage.addWarnings(storageParameters, (WarningsAware)folderAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitTransaction(StorageParameters storageParameters) throws OXException {
        IDBasedFolderAccess folderAccess = (IDBasedFolderAccess)storageParameters.getParameter(this.getFolderType(), PARAM);
        if (null != folderAccess) {
            try {
                folderAccess.commit();
            }
            finally {
                Session session;
                if (null != storageParameters.putParameter(this.getFolderType(), PARAM, null) && null != (session = storageParameters.getSession()) && session.containsParameter(Connection.class.getName() + '@' + Thread.currentThread().getId())) {
                    session.setParameter(Connection.class.getName() + '@' + Thread.currentThread().getId(), null);
                }
            }
            FileStorageFolderStorage.addWarnings(storageParameters, (WarningsAware)folderAccess);
        }
    }

    @Override
    public void clearCache(int userId, int contextId) {
    }

    @Override
    public void restore(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public Folder prepareFolder(String treeId, Folder folder, StorageParameters storageParameters) throws OXException {
        return folder;
    }

    @Override
    public void checkConsistency(String treeId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public SortableId[] getVisibleFolders(String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        throw new UnsupportedOperationException("FileStorageFolderStorage.getVisibleSubfolders()");
    }

    @Override
    public SortableId[] getUserSharedFolders(String treeId, ContentType contentType, StorageParameters storageParameters) throws OXException {
        if (!FileStorageContentType.class.isInstance(contentType)) {
            throw FolderExceptionErrorMessage.UNKNOWN_CONTENT_TYPE.create(contentType.toString());
        }
        IDBasedFolderAccess folderAccess = FileStorageFolderStorage.getFolderAccess(storageParameters);
        FileStorageFolder[] sharedFolders = folderAccess.getUserSharedFolders();
        if (null == sharedFolders) {
            return null;
        }
        SortableId[] sortableIds = new SortableId[sharedFolders.length];
        for (int i = 0; i < sharedFolders.length; ++i) {
            sortableIds[i] = new FileStorageId(sharedFolders[i].getId(), i, sharedFolders[i].getName());
        }
        return sortableIds;
    }

    @Override
    public ContentType[] getSupportedContentTypes() {
        return new ContentType[]{FileStorageContentType.getInstance()};
    }

    @Override
    public ContentType getDefaultContentType() {
        return FileStorageContentType.getInstance();
    }

    @Override
    public void createFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        IDBasedFolderAccess folderAccess = FileStorageFolderStorage.getFolderAccess(storageParameters);
        DefaultFileStorageFolder fsFolder = new DefaultFileStorageFolder();
        fsFolder.setExists(false);
        fsFolder.setParentId(folder.getParentID());
        fsFolder.setName(folder.getName());
        fsFolder.setSubscribed(folder.isSubscribed());
        Permission[] permissions = folder.getPermissions();
        if (null != permissions && permissions.length > 0) {
            ArrayList<DefaultFileStoragePermission> fsPermissions = new ArrayList<DefaultFileStoragePermission>(permissions.length);
            for (Permission permission : permissions) {
                DefaultFileStoragePermission fsPerm = DefaultFileStoragePermission.newInstance();
                fsPerm.setEntity(permission.getEntity());
                fsPerm.setAllPermissions(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission());
                fsPerm.setAdmin(permission.isAdmin());
                fsPerm.setGroup(permission.isGroup());
                fsPermissions.add(fsPerm);
            }
            fsFolder.setPermissions(fsPermissions);
        } else if ("".equals(folder.getParentID())) {
            FileStoragePermission[] messagingPermissions = new FileStoragePermission[1];
            DefaultFileStoragePermission fsPerm = DefaultFileStoragePermission.newInstance();
            fsPerm.setEntity(storageParameters.getUserId());
            fsPerm.setAllPermissions(128, 128, 128, 128);
            fsPerm.setAdmin(true);
            fsPerm.setGroup(false);
            messagingPermissions[0] = fsPerm;
            fsFolder.setPermissions(Arrays.asList(messagingPermissions));
        } else {
            FileStorageFolder parent = folderAccess.getFolder(folder.getParentID());
            List parentPermissions = parent.getPermissions();
            FileStoragePermission[] ffPermissions = new FileStoragePermission[parentPermissions.size()];
            int i = 0;
            for (FileStoragePermission parentPerm : parentPermissions) {
                DefaultFileStoragePermission fsPerm = DefaultFileStoragePermission.newInstance();
                fsPerm.setEntity(parentPerm.getEntity());
                fsPerm.setAllPermissions(parentPerm.getFolderPermission(), parentPerm.getReadPermission(), parentPerm.getWritePermission(), parentPerm.getDeletePermission());
                fsPerm.setAdmin(parentPerm.isAdmin());
                fsPerm.setGroup(parentPerm.isGroup());
                ffPermissions[i++] = fsPerm;
            }
            fsFolder.setPermissions(Arrays.asList(ffPermissions));
        }
        String fullName = folderAccess.createFolder((FileStorageFolder)fsFolder);
        folder.setID(fullName);
    }

    @Override
    public void clearFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        boolean hardDelete = StorageParametersUtility.getBoolParameter("hardDelete", storageParameters);
        FileStorageFolderStorage.getFolderAccess(storageParameters).clearFolder(folderId, hardDelete);
    }

    @Override
    public void deleteFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        boolean hardDelete = StorageParametersUtility.getBoolParameter("hardDelete", storageParameters);
        FileStorageFolderStorage.getFolderAccess(storageParameters).deleteFolder(folderId, hardDelete);
    }

    @Override
    public String getDefaultFolderID(User user, String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        if (!(contentType instanceof FileStorageContentType)) {
            throw FolderExceptionErrorMessage.UNKNOWN_CONTENT_TYPE.create(contentType.toString());
        }
        return INFOSTORE;
    }

    @Override
    public Type getTypeByParent(User user, String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        return FileStorageType.getInstance();
    }

    @Override
    public boolean containsForeignObjects(User user, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        IDBasedFolderAccess folderAccess = FileStorageFolderStorage.getFolderAccess(storageParameters);
        if (!folderAccess.exists(folderId)) {
            FolderID folderID = new FolderID(folderId);
            throw FileStorageExceptionCodes.FOLDER_NOT_FOUND.create(new Object[]{folderID.getFolderId(), Integer.valueOf(folderID.getAccountId()), folderID.getService(), storageParameters.getUserId(), storageParameters.getContextId()});
        }
        return false;
    }

    @Override
    public boolean isEmpty(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return 1 > FileStorageFolderStorage.getFolderAccess(storageParameters).getFolder(folderId).getFileCount();
    }

    @Override
    public void updateLastModified(long lastModified, String treeId, String folderId, StorageParameters storageParameters) throws OXException {
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageParameters storageParameters) throws OXException {
        return this.getFolders(treeId, folderIds, StorageType.WORKING, storageParameters);
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIds, StorageType storageType, StorageParameters storageParameters) throws OXException {
        ArrayList<Folder> ret = new ArrayList<Folder>(folderIds.size());
        for (String folderId : folderIds) {
            ret.add(this.getFolder(treeId, folderId, storageType, storageParameters));
        }
        return ret;
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.getFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public Folder getFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        if (StorageType.BACKUP.equals(storageType)) {
            throw FolderExceptionErrorMessage.UNSUPPORTED_STORAGE_TYPE.create(storageType);
        }
        FolderID fid = new FolderID(folderId);
        FileStorageFolder fsFolder = FileStorageFolderStorage.getFolderAccess(storageParameters).getFolder(fid);
        boolean altNames = StorageParametersUtility.getBoolParameter("altNames", storageParameters);
        String accountID = FileStorageAccounts.getQualifiedID((String)fid.getService(), (String)fid.getAccountId());
        Session session = storageParameters.getSession();
        FileStorageFolderImpl retval = session == null ? new FileStorageFolderImpl(fsFolder, accountID, storageParameters.getUserId(), storageParameters.getContextId(), altNames) : new FileStorageFolderImpl(fsFolder, accountID, session, altNames);
        boolean hasSubfolders = fsFolder.hasSubfolders();
        retval.setTreeID(treeId);
        retval.setSubfolderIDs(hasSubfolders ? null : new String[]{});
        return retval;
    }

    @Override
    public FolderType getFolderType() {
        return FileStorageFolderType.getInstance();
    }

    @Override
    public SortableId[] getSubfolders(String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        IDBasedFolderAccess folderAccess = (IDBasedFolderAccess)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null == folderAccess) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        boolean isRealTree = REAL_TREE_ID.equals(treeId);
        if (isRealTree ? PRIVATE_FOLDER_ID.equals(parentId) : INFOSTORE.equals(parentId)) {
            FileStorageFolder[] rootFolders;
            int size;
            User user;
            Locale userLocale = null;
            if (storageParameters.getSession() != null && (user = ServerSessionAdapter.valueOf(storageParameters.getSession()).getUser()) != null) {
                userLocale = user.getLocale();
            }
            if (null == userLocale) {
                userLocale = storageParameters.getUser().getLocale();
            }
            if ((size = (rootFolders = folderAccess.getRootFolders(userLocale)).length) <= 0) {
                return new SortableId[0];
            }
            ArrayList<FileStorageId> list = new ArrayList<FileStorageId>(size);
            if (isRealTree) {
                int index = 0;
                for (int j = 0; j < size; ++j) {
                    String id = rootFolders[j].getId();
                    if (id.length() == 0 || INFOSTORE_ACCOUNT_ID.equals(new FolderID(id).getAccountId())) continue;
                    list.add(new FileStorageId(id, index++, null));
                }
            } else {
                for (int j = 0; j < size; ++j) {
                    list.add(new FileStorageId(rootFolders[j].getId(), j, null));
                }
            }
            return list.toArray(new SortableId[list.size()]);
        }
        List<FileStorageFolder> children = Arrays.asList(folderAccess.getSubfolders(parentId, true));
        Collections.sort(children, new SimpleFileStorageFolderComparator(storageParameters.getUser().getLocale()));
        ArrayList<FileStorageId> list = new ArrayList<FileStorageId>(children.size());
        int size = children.size();
        for (int j = 0; j < size; ++j) {
            FileStorageFolder cur = children.get(j);
            list.add(new FileStorageId(cur.getId(), j, cur.getName()));
        }
        return list.toArray(new SortableId[list.size()]);
    }

    @Override
    public StoragePriority getStoragePriority() {
        return StoragePriority.NORMAL;
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        return this.containsFolder(treeId, folderId, StorageType.WORKING, storageParameters);
    }

    @Override
    public boolean containsFolder(String treeId, String folderId, StorageType storageType, StorageParameters storageParameters) throws OXException {
        if (StorageType.BACKUP.equals(storageType)) {
            return false;
        }
        IDBasedFolderAccess folderAccess = FileStorageFolderStorage.getFolderAccess(storageParameters);
        return folderAccess.exists(folderId);
    }

    @Override
    public String[] getDeletedFolderIDs(String treeId, Date timeStamp, StorageParameters storageParameters) throws OXException {
        return new String[0];
    }

    @Override
    public String[] getModifiedFolderIDs(String treeId, Date timeStamp, ContentType[] includeContentTypes, StorageParameters storageParameters) throws OXException {
        if (null == includeContentTypes || includeContentTypes.length == 0) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        HashSet<ContentType> supported = new HashSet<ContentType>(Arrays.asList(this.getSupportedContentTypes()));
        for (ContentType includeContentType : includeContentTypes) {
            SortableId[] subfolders;
            if (!supported.contains(includeContentType)) continue;
            for (SortableId sortableId : subfolders = this.getSubfolders(FolderStorage.REAL_TREE_ID, PRIVATE_FOLDER_ID, storageParameters)) {
                ret.add(sortableId.getId());
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public void updateFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        boolean permissions;
        IDBasedFolderAccess folderAccess = FileStorageFolderStorage.getFolderAccess(storageParameters);
        DefaultFileStorageFolder folderToUpdate = FileStorageFolderStorage.getFileStorageFolder(folder);
        FileStorageFolder originalFolder = folderAccess.getFolder(folder.getID());
        boolean move = null != folderToUpdate.getParentId() && false == originalFolder.getParentId().equals(folderToUpdate.getParentId());
        boolean rename = null != folderToUpdate.getName() && false == originalFolder.getName().equals(folderToUpdate.getName());
        boolean bl = permissions = null != folderToUpdate.getPermissions() && 0 < folderToUpdate.getPermissions().size() && false == folderToUpdate.getPermissions().equals(originalFolder.getPermissions());
        if (move) {
            boolean ignoreWarnings = StorageParametersUtility.getBoolParameter("ignoreWarnings", storageParameters);
            String newName = rename ? folderToUpdate.getName() : null;
            String newID = folderAccess.moveFolder(folderToUpdate.getId(), folderToUpdate.getParentId(), newName, ignoreWarnings);
            folderToUpdate.setId(newID);
        } else if (rename) {
            String newID = folderAccess.renameFolder(folderToUpdate.getId(), folderToUpdate.getName());
            folderToUpdate.setId(newID);
        }
        if (permissions) {
            String newID = folderAccess.updateFolder(folderToUpdate.getId(), (FileStorageFolder)folderToUpdate);
            folderToUpdate.setId(newID);
            if (StorageParametersUtility.isHandDownPermissions(storageParameters)) {
                FileStorageFolderStorage.handDown(folderToUpdate.getId(), folderToUpdate.getPermissions(), folderAccess);
            }
        }
        folder.setID(folderToUpdate.getId());
        folder.setParentID(folderToUpdate.getParentId());
        folder.setLastModified(folderToUpdate.getLastModifiedDate());
    }

    private static void handDown(String parentId, List<FileStoragePermission> fsPermissions, IDBasedFolderAccess folderAccess) throws OXException {
        FileStorageFolder[] subfolders;
        for (FileStorageFolder subfolder : subfolders = folderAccess.getSubfolders(parentId, true)) {
            DefaultFileStorageFolder fsFolder = new DefaultFileStorageFolder();
            fsFolder.setExists(true);
            String id = subfolder.getId();
            fsFolder.setId(id);
            fsFolder.setPermissions(fsPermissions);
            folderAccess.updateFolder(id, (FileStorageFolder)fsFolder);
            FileStorageFolderStorage.handDown(id, fsPermissions, folderAccess);
        }
    }

    private static IDBasedFolderAccess getFolderAccess(StorageParameters storageParameters) throws OXException {
        IDBasedFolderAccess folderAccess = (IDBasedFolderAccess)storageParameters.getParameter(FileStorageFolderType.getInstance(), PARAM);
        if (null == folderAccess) {
            throw FolderExceptionErrorMessage.MISSING_PARAMETER.create(PARAM);
        }
        return folderAccess;
    }

    private static DefaultFileStorageFolder getFileStorageFolder(Folder folder) {
        DefaultFileStorageFolder fileStorageFolder = new DefaultFileStorageFolder();
        fileStorageFolder.setExists(true);
        fileStorageFolder.setId(folder.getID());
        fileStorageFolder.setParentId(folder.getParentID());
        fileStorageFolder.setName(folder.getName());
        if (!SetterAwareFolder.class.isInstance(fileStorageFolder) || ((SetterAwareFolder)folder).containsSubscribed()) {
            fileStorageFolder.setSubscribed(folder.isSubscribed());
        }
        fileStorageFolder.setPermissions(FileStorageFolderStorage.getfFileStoragePermissions(folder.getPermissions()));
        fileStorageFolder.setCreatedBy(folder.getCreatedBy());
        fileStorageFolder.setModifiedBy(folder.getModifiedBy());
        return fileStorageFolder;
    }

    private static List<FileStoragePermission> getfFileStoragePermissions(Permission[] permissions) {
        if (null != permissions && 0 < permissions.length) {
            ArrayList<FileStoragePermission> fileStoragePermissions = new ArrayList<FileStoragePermission>(permissions.length);
            for (Permission permission : permissions) {
                fileStoragePermissions.add(FileStorageFolderStorage.getfFileStoragePermissions(permission));
            }
            return fileStoragePermissions;
        }
        return null;
    }

    private static FileStoragePermission getfFileStoragePermissions(Permission permission) {
        DefaultFileStoragePermission fileStoragePermission = DefaultFileStoragePermission.newInstance();
        fileStoragePermission.setEntity(permission.getEntity());
        fileStoragePermission.setAllPermissions(permission.getFolderPermission(), permission.getReadPermission(), permission.getWritePermission(), permission.getDeletePermission());
        fileStoragePermission.setAdmin(permission.isAdmin());
        fileStoragePermission.setGroup(permission.isGroup());
        return fileStoragePermission;
    }

    private static void addWarnings(StorageParameters storageParameters, WarningsAware warningsAware) {
        List list = warningsAware.getAndFlushWarnings();
        if (null != list && !list.isEmpty()) {
            for (OXException warning : list) {
                storageParameters.addWarning(warning);
            }
        }
    }

    private static final class SimpleFileStorageFolderComparator
    implements Comparator<FileStorageFolder> {
        private final Collator collator;

        SimpleFileStorageFolderComparator(Locale locale) {
            this.collator = Collators.getSecondaryInstance((Locale)locale);
        }

        @Override
        public int compare(FileStorageFolder o1, FileStorageFolder o2) {
            return this.collator.compare(o1.getName(), o2.getName());
        }
    }
}

